/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.loot;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import ovh.corail.tombstone.helper.EffectHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.registry.ModLootFunctions;

public class RandomPotionFunction
extends LootItemConditionalFunction {
    public static final ResourceLocation RL = ResourceLocation.fromNamespaceAndPath((String)"tombstone", (String)"random_potion");
    public static final MapCodec<RandomPotionFunction> CODEC = RecordCodecBuilder.mapCodec(b -> RandomPotionFunction.commonFields((RecordCodecBuilder.Instance)b).apply((Applicative)b, RandomPotionFunction::new));

    protected RandomPotionFunction(List<LootItemCondition> conditionsIn) {
        super(conditionsIn);
    }

    public LootItemFunctionType<? extends LootItemConditionalFunction> getType() {
        return ModLootFunctions.RANDOM_POTION;
    }

    protected ItemStack run(ItemStack stack, LootContext context) {
        Holder<Potion> potionHolder = RegistryHelper.findRandomHolder(BuiltInRegistries.POTION, h -> true).orElse((Holder<Potion>)Potions.HEALING);
        if (!EffectHelper.isPotionEnabled(potionHolder)) {
            return ItemStack.EMPTY;
        }
        int random = Helper.RANDOM.nextInt(3);
        return PotionContents.createItemStack((Item)(random == 0 ? Items.POTION : (random == 1 ? Items.SPLASH_POTION : Items.LINGERING_POTION)), potionHolder);
    }

    public static class Builder
    extends LootItemConditionalFunction.Builder<Builder> {
        protected Builder getThis() {
            return this;
        }

        public LootItemFunction build() {
            return new RandomPotionFunction(this.getConditions());
        }
    }
}

