/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.function.BooleanSupplier;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGraveMagic;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModPerks;

public abstract class ItemTablet
extends ItemGraveMagic {
    private static final int MAX_USE_COUNT = 10;

    public ItemTablet(String name, BooleanSupplier supplierBoolean) {
        super(name, ItemTablet.getBuilder().component(ModDataComponents.USE_COUNT, (Object)10), supplierBoolean);
    }

    @Override
    public void fillItemCategory(CreativeModeTab.Output toAdd) {
        if (this.isEnabled()) {
            toAdd.accept(new ItemStack((ItemLike)this));
            toAdd.accept(this.createAncient());
        }
    }

    @Override
    protected int getCastingCooldown() {
        return TimeHelper.tickFromSecond((Integer)SharedConfigTombstone.magic_item.tabletCooldown.get());
    }

    protected int getUseCount(ItemStack stack) {
        if (stack.getItem() == this) {
            return Math.min((Integer)stack.getOrDefault(ModDataComponents.USE_COUNT, (Object)10), 10);
        }
        return 0;
    }

    @Override
    protected ItemStack onConsumeItem(Player player, ItemStack stack) {
        if (Helper.RANDOM.nextInt(10) > EntityHelper.getPerkLevelWithBonus(player, ModPerks.rune_inscriber)) {
            int useCount = this.getUseCount(stack);
            if (useCount < 2) {
                stack.shrink(1);
                return stack;
            }
            stack.set(ModDataComponents.USE_COUNT, (Object)Math.min(--useCount, 10));
            int cd = this.getCastingCooldown();
            if (cd > 0) {
                this.setCooldown(player.level(), stack, cd);
            }
        }
        return stack;
    }

    public ItemStack createAncient() {
        ItemStack stack = new ItemStack((ItemLike)this);
        stack.set(ModDataComponents.ANCIENT, (Object)true);
        return stack;
    }

    public boolean isBarVisible(ItemStack stack) {
        return (Integer)stack.getOrDefault(ModDataComponents.USE_COUNT, (Object)10) < 10;
    }

    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)(1.0 - this.getDurability(stack))) / 1.5f), (float)1.0f, (float)1.0f);
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f - (float)this.getDurability(stack) * 13.0f);
    }

    private double getDurability(ItemStack stack) {
        return 1.0 - (double)this.getUseCount(stack) / 10.0;
    }
}

