/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import ovh.corail.tombstone.api.item.ISoulConsumer;
import ovh.corail.tombstone.capability.TBPlayerCapabilityHandler;
import ovh.corail.tombstone.config.SharedConfigTombstone;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.item.ItemBook;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemBookOfOblivion
extends ItemBook {
    public ItemBookOfOblivion() {
        super("book_of_oblivion", () -> SharedConfigTombstone.allowed_magic_items.allowBookOfOblivion.get());
    }

    @Override
    public ISoulConsumer.ConsumeResult setEnchant(Level level, BlockPos gravePos, ServerPlayer player, ItemStack stack, int soulStrength) {
        if (stack.getItem() != this) {
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]));
        }
        int cd = CooldownHandler.INSTANCE.getCooldown((Player)player, CooldownHandler.CooldownType.RESET_PERKS);
        if (cd > 0) {
            int min = cd / 1200;
            if (min > 0) {
                cd -= min * 1200;
            }
            return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_IN_COOLDOWN.getText(min, cd / 20));
        }
        if (TBPlayerCapabilityHandler.getPerks((Player)player).entrySet().stream().anyMatch(entry -> entry.getKey() != null && (Integer)entry.getValue() > 0 && !((Perk)entry.getKey()).isDisabled((Player)player))) {
            CooldownHandler.INSTANCE.setMaxCooldown(player, CooldownHandler.CooldownType.RESET_PERKS);
            TBPlayerCapabilityHandler.resetPerks(player);
            stack.shrink(1);
            ModTriggers.use_oblivion.trigger(player);
            return ISoulConsumer.ConsumeResult.success((Component)LangKey.MESSAGE_PERK_RESET_SUCCESS.getText(new Object[0]), 1);
        }
        return ISoulConsumer.ConsumeResult.fail((Component)LangKey.MESSAGE_PERK_RESET_FAILED.getText(new Object[0]));
    }

    @Override
    public int getKnowledge() {
        return 0;
    }
}

