/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.events_on_client;

import com.minecraftserverzone.weaponmaster.itemlayers.HumanoidItemLayer;
import com.minecraftserverzone.weaponmaster.renderer.quiver.QuiverWithArrowsModel;
import com.minecraftserverzone.weaponmaster.setup.KeyHandler;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;

@EventBusSubscriber(modid="weaponmaster_ydm", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientOnlyModSetup {
    @SubscribeEvent
    public static void registerKeybinds(RegisterKeyMappingsEvent event) {
        event.register(KeyHandler.OPEN_SCREEN);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(QuiverWithArrowsModel.LAYER_LOCATION, QuiverWithArrowsModel::createBodyLayer);
        event.registerLayerDefinition(QuiverWithArrowsModel.ARROWS_LAYER_LOCATION, QuiverWithArrowsModel::createArrowBodyLayer);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers evt) {
        evt.getSkins().forEach(s -> {
            EntityRenderer renderer = evt.getSkin(s);
            if (renderer instanceof LivingEntityRenderer) {
                LivingEntityRenderer livingRenderer = (LivingEntityRenderer)renderer;
                livingRenderer.addLayer(new HumanoidItemLayer(livingRenderer));
            }
        });
    }
}

