/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.custom_nether_portals.mixin;

import com.leclowndu93150.custom_nether_portals.CNPBlocks;
import com.leclowndu93150.custom_nether_portals.mixin.PoiTypesAccessor;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PoiTypes.class})
public class PoiTypesMixin {
    @Inject(method={"forState"}, at={@At(value="RETURN")}, cancellable=true)
    private static void addHorizontalPortalPoi(BlockState state, CallbackInfoReturnable<Optional<Holder<PoiType>>> cir) {
        if (((Optional)cir.getReturnValue()).isEmpty() && state.getBlock() == CNPBlocks.HORIZONTAL_NETHER_PORTAL) {
            Map<BlockState, Holder<PoiType>> typeByState = PoiTypesAccessor.getTypeByState();
            for (BlockState portalState : Blocks.NETHER_PORTAL.getStateDefinition().getPossibleStates()) {
                Holder<PoiType> holder = typeByState.get(portalState);
                if (holder == null) continue;
                cir.setReturnValue(Optional.of(holder));
                break;
            }
        }
    }

    @Inject(method={"hasPoi"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hasHorizontalPortalPoi(BlockState state, CallbackInfoReturnable<Boolean> cir) {
        if (state.getBlock() == CNPBlocks.HORIZONTAL_NETHER_PORTAL) {
            cir.setReturnValue((Object)true);
        }
    }
}

