/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.util;

import java.util.Collection;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MMHShapes {
    public static VoxelShape combineShapes(Collection<VoxelShape> shapes) {
        VoxelShape result = Shapes.empty();
        for (VoxelShape shape : shapes) {
            result = Shapes.joinUnoptimized((VoxelShape)result, (VoxelShape)shape, (BooleanOp)BooleanOp.OR);
        }
        return result.optimize();
    }

    public static VoxelShape[] getRotatedShapes(VoxelShape source) {
        VoxelShape shapeNorth = MMHShapes.rotate(source, Direction.NORTH);
        VoxelShape shapeEast = MMHShapes.rotate(source, Direction.EAST);
        VoxelShape shapeSouth = MMHShapes.rotate(source, Direction.SOUTH);
        VoxelShape shapeWest = MMHShapes.rotate(source, Direction.WEST);
        return new VoxelShape[]{shapeSouth, shapeWest, shapeNorth, shapeEast};
    }

    public static VoxelShape rotate(VoxelShape source, Direction direction) {
        double[] adjustedValues = MMHShapes.adjustValues(direction, source.min(Direction.Axis.X), source.min(Direction.Axis.Z), source.max(Direction.Axis.X), source.max(Direction.Axis.Z));
        return Shapes.box((double)adjustedValues[0], (double)source.min(Direction.Axis.Y), (double)adjustedValues[1], (double)adjustedValues[2], (double)source.max(Direction.Axis.Y), (double)adjustedValues[3]);
    }

    private static double[] adjustValues(Direction direction, double var1, double var2, double var3, double var4) {
        switch (direction) {
            case WEST: {
                double var_temp_1 = var1;
                var1 = 1.0 - var3;
                double var_temp_2 = var2;
                var2 = 1.0 - var4;
                var3 = 1.0 - var_temp_1;
                var4 = 1.0 - var_temp_2;
                break;
            }
            case NORTH: {
                double var_temp_3 = var1;
                var1 = var2;
                var2 = 1.0 - var3;
                var3 = var4;
                var4 = 1.0 - var_temp_3;
                break;
            }
            case SOUTH: {
                double var_temp_4 = var1;
                var1 = 1.0 - var4;
                double var_temp_5 = var2;
                var2 = var_temp_4;
                double var_temp_6 = var3;
                var3 = 1.0 - var_temp_5;
                var4 = var_temp_6;
                break;
            }
        }
        return new double[]{var1, var2, var3, var4};
    }
}

