/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.tree;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;

public class TreeGenBlock
extends BushBlock {
    public static final MapCodec<TreeGenBlock> CODEC = TreeGenBlock.simpleCodec(TreeGenBlock::new);
    public static final IntegerProperty SECTION = IntegerProperty.create((String)"section", (int)0, (int)2);
    protected static final VoxelShape SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public TreeGenBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        return SHAPE;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        Block block = level.getBlockState(pos.below()).getBlock();
        if ((Integer)state.getValue((Property)SECTION) == 0) {
            return block == Blocks.GRASS_BLOCK || block == Blocks.DIRT || block == Blocks.COARSE_DIRT || block == Blocks.PODZOL || block == Blocks.FARMLAND || block != Blocks.SAND || block != Blocks.GRAVEL || block != Blocks.AIR;
        }
        return false;
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.below();
        if (pState.getBlock() == this && (Integer)pState.getValue((Property)SECTION) == 0) {
            TriState soilDecision = pLevel.getBlockState(pPos.below()).canSustainPlant((BlockGetter)pLevel, pPos.below(), Direction.UP, pState);
            if (!soilDecision.isDefault()) {
                return soilDecision.isTrue();
            }
            return super.canSurvive(pState, pLevel, pPos);
        }
        return this.mayPlaceOn(pLevel.getBlockState(blockpos), (BlockGetter)pLevel, blockpos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{SECTION});
    }
}

