/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.tree;

import com.mamailes.merrymaking.init.MMItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TopperBlock
extends Block {
    protected static final VoxelShape TOPPER_AABB = Block.box((double)0.0, (double)-3.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final IntegerProperty TOPPER = IntegerProperty.create((String)"topper", (int)0, (int)2);

    public TopperBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TOPPER, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        return TOPPER_AABB;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TOPPER});
        super.createBlockStateDefinition(builder);
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if ((Integer)state.getValue((Property)TOPPER) == 1) {
            return 10;
        }
        return super.getLightEmission(state, level, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (!level.isClientSide()) {
            if ((Integer)state.getValue((Property)TOPPER) == 0) {
                if (heldItem.getItem() == MMItems.STAR.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TOPPER, (Comparable)Integer.valueOf(1)));
                    heldItem.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (heldItem.getItem() == MMItems.BOW.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TOPPER, (Comparable)Integer.valueOf(2)));
                    heldItem.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
            }
            if ((Integer)state.getValue((Property)TOPPER) == 1) {
                if (stack.getItem() == MMItems.BOW.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TOPPER, (Comparable)Integer.valueOf(2)));
                    heldItem.shrink(1);
                    player.addItem(new ItemStack((ItemLike)MMItems.STAR.get()));
                    return ItemInteractionResult.CONSUME;
                }
                if (stack.getItem() == MMItems.STAR.get()) {
                    return ItemInteractionResult.FAIL;
                }
            }
            if ((Integer)state.getValue((Property)TOPPER) == 2) {
                if (stack.getItem() == MMItems.STAR.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TOPPER, (Comparable)Integer.valueOf(1)));
                    heldItem.shrink(1);
                    player.addItem(new ItemStack((ItemLike)MMItems.BOW.get()));
                    return ItemInteractionResult.CONSUME;
                }
                if (stack.getItem() == MMItems.BOW.get()) {
                    return ItemInteractionResult.FAIL;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            if ((Integer)state.getValue((Property)TOPPER) == 1) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                player.addItem(new ItemStack((ItemLike)MMItems.STAR.get()));
                return InteractionResult.SUCCESS;
            }
            if ((Integer)state.getValue((Property)TOPPER) == 2) {
                level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                player.addItem(new ItemStack((ItemLike)MMItems.BOW.get()));
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if ((Integer)state.getValue((Property)TOPPER) == 2) {
            TopperBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MMItems.BOW.get()));
        }
        if ((Integer)state.getValue((Property)TOPPER) == 1) {
            TopperBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)MMItems.STAR.get()));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        if ((Integer)state.getValue((Property)TOPPER) == 2) {
            return new ItemStack((ItemLike)MMItems.BOW.get());
        }
        return new ItemStack((ItemLike)MMItems.STAR.get());
    }
}

