/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block.lamppost;

import com.mamailes.merrymaking.block.deco.base.HorizontalDecoBlock;
import com.mamailes.merrymaking.init.MMBlocks;
import com.mamailes.merrymaking.init.MMItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LampPost
extends HorizontalDecoBlock {
    protected static final VoxelShape SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final IntegerProperty DECO = IntegerProperty.create((String)"deco", (int)0, (int)4);
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");
    public static final BooleanProperty UP = BooleanProperty.create((String)"up");
    public static final BooleanProperty DOWN = BooleanProperty.create((String)"down");
    public static final BooleanProperty BOTH = BooleanProperty.create((String)"both");
    protected final ParticleOptions flameParticle;

    public LampPost(BlockBehaviour.Properties properties, ParticleOptions p_57492_) {
        super(properties);
        this.flameParticle = p_57492_;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)DIRECTION, (Comparable)Direction.NORTH)).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)BOTH, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)DECO, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter p_48946_, BlockPos p_48947_, CollisionContext p_48948_) {
        return SHAPE;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{UP});
        builder.add(new Property[]{DOWN});
        builder.add(new Property[]{BOTH});
        builder.add(new Property[]{LIT});
        builder.add(new Property[]{DECO});
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)DIRECTION, (Comparable)pContext.getHorizontalDirection());
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        boolean up = level.getBlockState(pos.above()).getBlock() == this;
        boolean down = level.getBlockState(pos.below()).getBlock() == this;
        boolean both = up && down;
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)DIRECTION, (Comparable)((Direction)state.getValue((Property)DIRECTION)))).setValue((Property)DECO, (Comparable)((Integer)state.getValue((Property)DECO)))).setValue((Property)LIT, (Comparable)((Boolean)state.getValue((Property)LIT)))).setValue((Property)UP, (Comparable)Boolean.valueOf(up))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(down))).setValue((Property)BOTH, (Comparable)Boolean.valueOf(both));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if ((Integer)state.getValue((Property)DECO) == 3 || (Integer)state.getValue((Property)DECO) == 4 || ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            return 15;
        }
        return super.getLightEmission(state, level, pos);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult pHitResult) {
        boolean isPole;
        ItemStack item = player.getItemInHand(hand);
        boolean isTop = (Boolean)state.getValue((Property)DOWN);
        boolean isSingle = (Boolean)state.getValue((Property)UP) == false && (Boolean)state.getValue((Property)DOWN) == false && (Boolean)state.getValue((Property)BOTH) == false;
        boolean bl = isPole = (Boolean)state.getValue((Property)UP) != false && (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)BOTH) != false;
        if (!level.isClientSide()) {
            if ((isTop || isSingle && !((Boolean)state.getValue((Property)LIT)).booleanValue()) && item.getItem() == Items.TORCH && !isPole) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)));
                item.shrink(1);
                return ItemInteractionResult.CONSUME;
            }
            if (isPole && (Integer)state.getValue((Property)DECO) == 0) {
                if (item.getItem() == MMItems.BOW.get()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(1)));
                    item.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (item.getItem() == ((Block)MMBlocks.CHRISTMAS_WREATH.get()).asItem()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(2)));
                    item.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (item.getItem() == ((Block)MMBlocks.CHRISTMAS_WREATH_WHITE_LIGHTS.get()).asItem()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(3)));
                    item.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                if (item.getItem() == ((Block)MMBlocks.CHRISTMAS_WREATH_MULTI_LIGHTS.get()).asItem()) {
                    level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(4)));
                    item.shrink(1);
                    return ItemInteractionResult.CONSUME;
                }
                return ItemInteractionResult.FAIL;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, pHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        boolean isTop;
        boolean isSingle = (Boolean)state.getValue((Property)UP) == false && (Boolean)state.getValue((Property)DOWN) == false && (Boolean)state.getValue((Property)BOTH) == false;
        boolean isPole = (Boolean)state.getValue((Property)UP) != false && (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)BOTH) != false;
        boolean bl = isTop = (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)BOTH) == false && (Boolean)state.getValue((Property)UP) == false && (Boolean)state.getValue((Property)BOTH) == false;
        if (!level.isClientSide()) {
            if (((Boolean)state.getValue((Property)LIT)).booleanValue() && isSingle || ((Boolean)state.getValue((Property)LIT)).booleanValue() && isTop) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)Items.TORCH));
            } else if ((Integer)state.getValue((Property)DECO) == 1 && isPole) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMItems.BOW.get()));
            } else if ((Integer)state.getValue((Property)DECO) == 2 && isPole) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.CHRISTMAS_WREATH.get()));
            } else if ((Integer)state.getValue((Property)DECO) == 3 && isPole) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.CHRISTMAS_WREATH_WHITE_LIGHTS.get()));
            } else if ((Integer)state.getValue((Property)DECO) == 4 && isPole) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue((Property)DECO, (Comparable)Integer.valueOf(0))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
                player.addItem(new ItemStack((ItemLike)MMBlocks.CHRISTMAS_WREATH_MULTI_LIGHTS.get()));
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource p_222596_) {
        boolean isSingle = (Boolean)state.getValue((Property)UP) == false && (Boolean)state.getValue((Property)DOWN) == false && (Boolean)state.getValue((Property)BOTH) == false;
        boolean isTop = (Boolean)state.getValue((Property)DOWN) != false && (Boolean)state.getValue((Property)BOTH) == false && (Boolean)state.getValue((Property)UP) == false && (Boolean)state.getValue((Property)BOTH) == false;
        double c1x = (double)pos.getX() + 0.5;
        double c1y = (double)pos.getY() + 0.65;
        double c1z = (double)pos.getZ() + 0.5;
        if ((isSingle || isTop) && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, c1x, c1y, c1z, 0.0, 0.0, 0.0);
            level.addParticle(this.flameParticle, c1x, c1y, c1z, 0.0, 0.0, 0.0);
        }
    }
}

