/*
 * Decompiled with CFR 0.152.
 */
package com.mamailes.merrymaking.block;

import com.mamailes.merrymaking.init.MMBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GrowableTinySpruce
extends Block
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)15.0, (double)12.0);

    public GrowableTinySpruce(BlockBehaviour.Properties p_48957_) {
        super(p_48957_);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getMaxLocalRawBrightness(pos.above()) >= 9 && randomSource.nextInt(7) == 0) {
            this.growTree((Level)level, pos);
        }
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).is(BlockTags.DIRT);
    }

    public ItemStack getCloneItemStack(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)Items.BAMBOO);
    }

    public boolean isValidBonemealTarget(LevelReader pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.getBlockState(pPos.above()).isAir();
    }

    public boolean isBonemealSuccess(Level p_220878_, RandomSource p_220879_, BlockPos p_220880_, BlockState p_220881_) {
        return true;
    }

    public void performBonemeal(ServerLevel level, RandomSource p_220875_, BlockPos pos, BlockState p_220877_) {
        this.growTree((Level)level, pos);
    }

    protected void growTree(Level pLevel, BlockPos pState) {
        pLevel.setBlock(pState, ((Block)MMBlocks.TREE_BOTTOM.get()).defaultBlockState(), 3);
        pLevel.setBlock(pState.above(), ((Block)MMBlocks.TREE_MIDDLE.get()).defaultBlockState(), 3);
        pLevel.setBlock(pState.above(2), ((Block)MMBlocks.TREE_TOP.get()).defaultBlockState(), 3);
    }

    public boolean isRandomlyTicking(BlockState pState) {
        return true;
    }
}

