/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.mobstein.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JarLungBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public JarLungBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.GLASS).strength(1.3f, 10.0f).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.getBlock() == this ? true : super.skipRendering(state, adjacentBlockState, side);
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)JarLungBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JarLungBlock.box((double)4.75, (double)10.25, (double)5.5, (double)11.25, (double)11.5, (double)10.5), JarLungBlock.box((double)5.5, (double)9.75, (double)6.0, (double)10.5, (double)11.0, (double)10.0), JarLungBlock.box((double)4.6, (double)2.0, (double)4.35, (double)11.55, (double)8.75, (double)11.8)});
            case Direction.NORTH -> Shapes.or((VoxelShape)JarLungBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JarLungBlock.box((double)4.75, (double)10.25, (double)5.5, (double)11.25, (double)11.5, (double)10.5), JarLungBlock.box((double)5.5, (double)9.75, (double)6.0, (double)10.5, (double)11.0, (double)10.0), JarLungBlock.box((double)4.45, (double)2.0, (double)4.2, (double)11.4, (double)8.75, (double)11.65)});
            case Direction.EAST -> Shapes.or((VoxelShape)JarLungBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JarLungBlock.box((double)5.5, (double)10.25, (double)4.75, (double)10.5, (double)11.5, (double)11.25), JarLungBlock.box((double)6.0, (double)9.75, (double)5.5, (double)10.0, (double)11.0, (double)10.5), JarLungBlock.box((double)4.35, (double)2.0, (double)4.45, (double)11.8, (double)8.75, (double)11.4)});
            case Direction.WEST -> Shapes.or((VoxelShape)JarLungBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{JarLungBlock.box((double)5.5, (double)10.25, (double)4.75, (double)10.5, (double)11.5, (double)11.25), JarLungBlock.box((double)6.0, (double)9.75, (double)5.5, (double)10.0, (double)11.0, (double)10.5), JarLungBlock.box((double)4.2, (double)2.0, (double)4.6, (double)11.65, (double)8.75, (double)11.55)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

