/*
 * Decompiled with CFR 0.152.
 */
package net.night.multi_arrow_effects.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.night.multi_arrow_effects.config.MultiArrowConfig;
import net.night.multi_arrow_effects.recipe.ModRecipes;

public class ArrowCombiningRecipe
extends CustomRecipe {
    public ArrowCombiningRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        ArrayList<ItemStack> tippedArrows = new ArrayList<ItemStack>();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.is(Items.TIPPED_ARROW)) {
                tippedArrows.add(stack);
                continue;
            }
            return false;
        }
        if (tippedArrows.size() < 2) {
            return false;
        }
        MultiArrowConfig config = MultiArrowConfig.getInstance();
        ArrayList<String> effectIds = new ArrayList<String>();
        for (ItemStack arrow : tippedArrows) {
            PotionContents potionContents = (PotionContents)arrow.get(DataComponents.POTION_CONTENTS);
            if (potionContents == null) continue;
            ArrayList effects = new ArrayList();
            potionContents.getAllEffects().forEach(effects::add);
            if (effects.isEmpty()) continue;
            effects.forEach(effect -> {
                String effectId = effect.getEffect().getRegisteredName();
                if (!effectIds.contains(effectId)) {
                    effectIds.add(effectId);
                }
            });
        }
        return config.canCombineEffects(effectIds);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider provider) {
        ArrayList<ItemStack> tippedArrows = new ArrayList<ItemStack>();
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty() || !stack.is(Items.TIPPED_ARROW)) continue;
            tippedArrows.add(stack);
        }
        if (tippedArrows.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack result = new ItemStack((ItemLike)Items.TIPPED_ARROW);
        ArrayList allEffects = new ArrayList();
        for (ItemStack arrow : tippedArrows) {
            PotionContents potionContents = (PotionContents)arrow.get(DataComponents.POTION_CONTENTS);
            if (potionContents == null) continue;
            potionContents.getAllEffects().forEach(allEffects::add);
        }
        MultiArrowConfig config = MultiArrowConfig.getInstance();
        int maxEffects = config.getMaxEffects();
        ArrayList<MobEffectInstance> uniqueEffects = new ArrayList<MobEffectInstance>();
        ArrayList<String> seenEffectIds = new ArrayList<String>();
        for (int i = allEffects.size() - 1; i >= 0; --i) {
            MobEffectInstance effect = (MobEffectInstance)allEffects.get(i);
            String effectId = effect.getEffect().getRegisteredName();
            if (seenEffectIds.contains(effectId)) continue;
            uniqueEffects.add(0, effect);
            seenEffectIds.add(effectId);
        }
        List<Object> finalEffects = new ArrayList();
        finalEffects = uniqueEffects.size() > maxEffects ? uniqueEffects.subList(uniqueEffects.size() - maxEffects, uniqueEffects.size()) : uniqueEffects;
        PotionContents combinedContents = new PotionContents(Optional.empty(), Optional.empty(), finalEffects);
        result.set(DataComponents.POTION_CONTENTS, (Object)combinedContents);
        result.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"item.multi_arrow_effects.mixed_arrow"));
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.ARROW_COMBINING_SERIALIZER.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        return NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
    }
}

