/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class SizedIngredient {
    public static final SizedIngredient EMPTY = new SizedIngredient(Ingredient.EMPTY, 1);
    public static final Codec<SizedIngredient> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Ingredient.MAP_CODEC_NONEMPTY.forGetter(SizedIngredient::ingredient), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(SizedIngredient::count)).apply((Applicative)instance, SizedIngredient::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SizedIngredient> STREAM_CODEC = StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, SizedIngredient::ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, SizedIngredient::count, SizedIngredient::new);
    private final Ingredient ingredient;
    private final int count;
    @Nullable
    private ItemStack[] cachedStacks;

    public static SizedIngredient of(ItemLike item, int count) {
        return new SizedIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}), count);
    }

    public static SizedIngredient of(TagKey<Item> tag, int count) {
        return new SizedIngredient(Ingredient.of(tag), count);
    }

    public SizedIngredient(Ingredient ingredient, int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Count must be positive");
        this.ingredient = ingredient;
        this.count = count;
    }

    public Ingredient ingredient() {
        return this.ingredient;
    }

    public int count() {
        return this.count;
    }

    public boolean test(ItemStack stack) {
        return this.ingredient.test(stack) && (stack.isEmpty() || stack.getCount() >= this.count);
    }

    public ItemStack[] getItems() {
        if (this.cachedStacks == null) {
            this.cachedStacks = (ItemStack[])Stream.of(this.ingredient.getItems()).map(s -> s.copyWithCount(this.count)).toArray(ItemStack[]::new);
        }
        return this.cachedStacks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SizedIngredient)) {
            return false;
        }
        SizedIngredient other = (SizedIngredient)o;
        return this.count == other.count && this.ingredient.equals((Object)other.ingredient);
    }

    public int hashCode() {
        return Objects.hash(this.ingredient, this.count);
    }

    public String toString() {
        return this.count + "x " + String.valueOf(this.ingredient);
    }
}

