/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.AbstractModule;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.contributor.ContributorsClient;
import snownee.kiwi.contributor.ITierProvider;
import snownee.kiwi.contributor.impl.KiwiTierProvider;
import snownee.kiwi.contributor.network.SSyncCosmeticPacket;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.loader.event.InitEvent;
import snownee.kiwi.network.KPacketSender;

@KiwiModule(value="contributors")
@KiwiModule.ClientCompanion(value=ContributorsClient.class)
public class Contributors
extends AbstractModule {
    public static final Map<String, ITierProvider> REWARD_PROVIDERS = Maps.newConcurrentMap();
    public static final Map<String, ResourceLocation> PLAYER_COSMETICS = Maps.newConcurrentMap();
    private static final Set<ResourceLocation> RENDERABLES = Sets.newLinkedHashSet();
    private static int DAY = Calendar.getInstance().get(5);

    public static boolean isContributor(String author, String playerName) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName);
    }

    public static boolean isContributor(String author, String playerName, String tier) {
        return REWARD_PROVIDERS.getOrDefault(author.toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE).isContributor(playerName, tier);
    }

    public static boolean isContributor(String author, Player player) {
        return Contributors.isContributor(author, player.getGameProfile().getName());
    }

    public static boolean isContributor(String author, Player player, String tier) {
        return Contributors.isContributor(author, player.getGameProfile().getName(), tier);
    }

    public static Set<ResourceLocation> getPlayerTiers(String playerName) {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getPlayerTiers(playerName).stream().map(s -> ResourceLocation.fromNamespaceAndPath((String)tp.getAuthor().toLowerCase(Locale.ENGLISH), (String)s))).collect(Collectors.toSet());
    }

    public static Set<ResourceLocation> getTiers() {
        return REWARD_PROVIDERS.values().stream().flatMap(tp -> tp.getTiers().stream().map(s -> ResourceLocation.fromNamespaceAndPath((String)tp.getAuthor().toLowerCase(Locale.ENGLISH), (String)s))).collect(Collectors.toSet());
    }

    public static void registerTierProvider(ITierProvider rewardProvider) {
        String namespace = rewardProvider.getAuthor().toLowerCase(Locale.ENGLISH);
        REWARD_PROVIDERS.put(namespace, rewardProvider);
        for (String tier : rewardProvider.getRenderableTiers()) {
            RENDERABLES.add(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tier));
        }
    }

    public static void changeCosmetic(ServerPlayer player, @Nullable ResourceLocation cosmetic) {
        String playerName = player.getGameProfile().getName();
        Contributors.canPlayerUseCosmetic(playerName, cosmetic).thenAccept(bl -> {
            if (bl.booleanValue()) {
                SSyncCosmeticPacket packet;
                if (cosmetic == null) {
                    PLAYER_COSMETICS.remove(playerName);
                    packet = new SSyncCosmeticPacket(Map.of(), List.of(playerName));
                } else {
                    PLAYER_COSMETICS.put(playerName, cosmetic);
                    packet = new SSyncCosmeticPacket(Map.of(playerName, cosmetic), List.of());
                }
                KPacketSender.sendToAll(packet, player.server);
            }
        });
    }

    public static boolean isRenderable(ResourceLocation id) {
        Contributors.refreshRenderables();
        return RENDERABLES.contains(id);
    }

    public static Set<ResourceLocation> getRenderableTiers() {
        Contributors.refreshRenderables();
        return Collections.unmodifiableSet(RENDERABLES);
    }

    private static void refreshRenderables() {
        int current = Calendar.getInstance().get(5);
        if (current != DAY) {
            DAY = current;
            RENDERABLES.clear();
            for (Map.Entry<String, ITierProvider> entry : REWARD_PROVIDERS.entrySet()) {
                String namespace = entry.getKey();
                for (String tier : entry.getValue().getRenderableTiers()) {
                    RENDERABLES.add(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)tier));
                }
            }
        }
    }

    public static CompletableFuture<Boolean> canPlayerUseCosmetic(String playerName, @Nullable ResourceLocation cosmetic) {
        if (cosmetic == null || cosmetic.getPath().isEmpty()) {
            return CompletableFuture.completedFuture(Boolean.TRUE);
        }
        if (!Contributors.isRenderable(cosmetic)) {
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        ITierProvider provider = REWARD_PROVIDERS.getOrDefault(cosmetic.getNamespace().toLowerCase(Locale.ENGLISH), ITierProvider.Empty.INSTANCE);
        if (!provider.isContributor(playerName, cosmetic.getPath())) {
            if (!Platform.isPhysicalClient()) {
                return provider.refresh().thenApply($ -> provider.isContributor(playerName, cosmetic.getPath()));
            }
            return CompletableFuture.completedFuture(Boolean.FALSE);
        }
        return CompletableFuture.completedFuture(Boolean.TRUE);
    }

    @Override
    protected void init(InitEvent event) {
        Contributors.registerTierProvider(new KiwiTierProvider());
        NeoForge.EVENT_BUS.addListener(e -> {
            Player player = e.getEntity();
            if (player.getServer() != null && !player.getServer().isSingleplayerOwner(player.getGameProfile())) {
                KPacketSender.send((CustomPacketPayload)new SSyncCosmeticPacket(Map.copyOf(PLAYER_COSMETICS), List.of()), player);
            }
        });
        if (!Platform.isPhysicalClient()) {
            NeoForge.EVENT_BUS.addListener(e -> PLAYER_COSMETICS.remove(e.getEntity().getGameProfile().getName()));
        }
    }
}

