/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.world.spawner;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Level;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.command.SpawnHordeCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.util.RandomExtention;
import net.petemc.undeadnights.util.SpawnLocationFinder;
import net.petemc.undeadnights.util.SpawnProcess;
import org.jetbrains.annotations.NotNull;

public class HordeSpawner
implements CustomSpawner {
    public static boolean invalidHordeMobEntry = false;
    public static int hordeIdFromHordesConfig = 1;
    public HashMap<UUID, HordeSpawnTask> hordeSpawningPerPlayer = new HashMap();
    public static int bossHordeTime;

    public SpawnHordeResult spawnHorde(ServerLevel level, ServerPlayer player, RandomExtention randomSource) {
        if (MainConfig.getEnableAsynchronousHordeSpawning()) {
            if (!this.hordeSpawningPerPlayer.containsKey(player.getUUID())) {
                this.hordeSpawningPerPlayer.put(player.getUUID(), new HordeSpawnTask(SpawnProcess.asynchronousHordeSpawner(level, player, randomSource), 10));
                if (MainConfig.getPrintDebugMessages()) {
                    player.sendSystemMessage((Component)Component.literal((String)"[DEBUG] Finding horde spawn location (async)...").withStyle(ChatFormatting.DARK_AQUA));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Async horde spawning location calculation for player {} at {}", (Object)player.getName().getString(), (Object)player.blockPosition());
                }
            }
            HordeSpawnTask existingHordeSpawnTask = this.hordeSpawningPerPlayer.get(player.getUUID());
            CompletableFuture<SpawnHordeResult> existingFutureSpawnHorde = existingHordeSpawnTask.futureResult;
            if (existingFutureSpawnHorde != null && existingFutureSpawnHorde.isDone()) {
                SpawnHordeResult result = SpawnHordeResult.FAILED;
                try {
                    result = existingFutureSpawnHorde.get();
                }
                catch (Exception e) {
                    UndeadNights.LOGGER.warn("Spawning horde for player {} failed!", (Object)player.getName().getString());
                }
                if (result == SpawnHordeResult.DONE) {
                    this.hordeSpawningPerPlayer.remove(player.getUUID());
                    return result;
                }
                if (existingHordeSpawnTask.tries > 0) {
                    --existingHordeSpawnTask.tries;
                    return SpawnHordeResult.NOT_DONE_YET;
                }
                this.hordeSpawningPerPlayer.remove(player.getUUID());
                return SpawnHordeResult.FAILED;
            }
        } else {
            return SpawnProcess.synchronousHordeSpawner(level, player, randomSource);
        }
        return SpawnHordeResult.NOT_DONE_YET;
    }

    public int tick(@NotNull ServerLevel level, boolean spawnMonsters, boolean spawnAnimals) {
        ServerPlayer serverPlayer;
        Entity entity;
        ServerPlayer player2;
        Iterator players;
        if (level.isClientSide()) {
            return 0;
        }
        if (!MainConfig.getUndeadNightsEnabled()) {
            return 0;
        }
        if (!spawnMonsters && !MainConfig.getIgnoreDoMobSpawningGamerule()) {
            return 0;
        }
        if (level.dimension() != Level.OVERWORLD) {
            return 0;
        }
        if (UndeadNights.serverState == null) {
            return 0;
        }
        long normalizedTimeOfDay = level.getDayTime() - level.getDayTime() / 24000L * 24000L;
        if (UndeadNights.serverState.getPrevNormalizedTimeOfDay() == normalizedTimeOfDay) {
            return 0;
        }
        UndeadNights.serverState.setNightIsStarting(UndeadNights.serverState.getPrevNormalizedTimeOfDay() < 12000L && normalizedTimeOfDay >= 12000L);
        UndeadNights.serverState.setPrevNormalizedTimeOfDay(normalizedTimeOfDay);
        boolean itIsNight = normalizedTimeOfDay >= 12000L && normalizedTimeOfDay < 22500L;
        boolean allDayLong = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getAllDayLongHordeNights() != false && UndeadNights.serverState.getHordeNight() && (normalizedTimeOfDay >= 22500L || normalizedTimeOfDay < 11000L);
        RandomExtention randomSource = new RandomExtention();
        int randomValue = 0;
        boolean withinBossHordeTime = false;
        if (UndeadNights.serverState.getHordeNight()) {
            if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getAllDayLongHordeNights().booleanValue()) {
                withinBossHordeTime = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getBossHordeEnabled() != false && normalizedTimeOfDay >= 9800L && normalizedTimeOfDay < 11000L;
            } else {
                boolean bl = withinBossHordeTime = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getBossHordeEnabled() != false && normalizedTimeOfDay >= 21300L && normalizedTimeOfDay < 22500L;
            }
            if (withinBossHordeTime && !UndeadNights.serverState.isSpawnBossHorde() && (long)bossHordeTime <= normalizedTimeOfDay) {
                UndeadNights.serverState.setSpawnBossHorde(true);
                players = level.getPlayers(LivingEntity::isAlive);
                if (!players.isEmpty()) {
                    Collections.shuffle(players);
                    randomValue = randomSource.nextInt(players.size());
                    player2 = (ServerPlayer)players.get(randomValue);
                    UndeadNights.serverState.entitiesWithPendingHorde.add(player2.getUUID());
                    UndeadNights.serverState.entitiesWithPendingWave.add(player2.getUUID());
                    UndeadNights.serverState.entitiesWithReceivedHorde.remove(player2.getUUID());
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Boss Horde Wave is spawning, NormalizedTimeOfDay: {}, BossHordeTime: {}", (Object)normalizedTimeOfDay, (Object)bossHordeTime);
                    }
                }
            }
        }
        if (!UndeadNights.serverState.entitiesWithPendingHorde.isEmpty()) {
            for (UUID playerUUID : UndeadNights.serverState.entitiesWithPendingHorde.stream().toList()) {
                SpawnHordeResult result;
                if (UndeadNights.serverState.entitiesWithReceivedHorde.contains(playerUUID) || !((entity = level.getEntity(playerUUID)) instanceof ServerPlayer)) continue;
                serverPlayer = (ServerPlayer)entity;
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Processing pending horde spawn for player {}.", (Object)serverPlayer.getName().getString());
                }
                if ((result = this.spawnHorde(level, serverPlayer, randomSource)) != SpawnHordeResult.FAILED && result != SpawnHordeResult.DONE) continue;
                if (result == SpawnHordeResult.DONE && MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Spawning horde for player {} succeeded.", (Object)serverPlayer.getName().getString());
                }
                UndeadNights.serverState.entitiesWithPendingHorde.remove(playerUUID);
                UndeadNights.serverState.entitiesWithReceivedHorde.add(playerUUID);
                if (result != SpawnHordeResult.FAILED) continue;
                UndeadNights.LOGGER.info("Spawning horde for player {} failed.", (Object)serverPlayer.getName().getString());
                if (!SpawnHordeCommand.spawnHordeByCommand) continue;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.command_spawn_horde_failed"));
                SpawnHordeCommand.spawnHordeByCommand = false;
            }
        }
        if (!UndeadNights.serverState.entitiesWithReceivedHorde.isEmpty()) {
            for (UUID playerUUID : UndeadNights.serverState.entitiesWithReceivedHorde.stream().toList()) {
                entity = level.getEntity(playerUUID);
                if (!(entity instanceof ServerPlayer) || (serverPlayer = (ServerPlayer)entity).hasEffect(ModEffects.LURE_HORDE) || serverPlayer.hasEffect(ModEffects.STRONG_LURE_HORDE)) continue;
                UndeadNights.serverState.entitiesWithReceivedHorde.remove(playerUUID);
            }
        }
        if (itIsNight || allDayLong) {
            UndeadNights.serverState.setPerformDifficultySwitchCheck(true);
            if (UndeadNights.serverState.getRespawnZombies() && UndeadNights.serverState.getHordeNight() && UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().isSpawnAdditionalWaves().booleanValue()) {
                if (UndeadNights.serverState.getTickCounter() > 0 && !UndeadNights.serverState.isSpawnBossHorde()) {
                    UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                    return 0;
                }
                UndeadNights.serverState.setTickCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getCooldownBetweenWaves() * 20);
                if (!UndeadNights.serverState.isSpawnBossHorde() && !withinBossHordeTime) {
                    randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                    if (randomValue > 100 - UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getChanceForAdditionalWave()) {
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("New Wave, randomValue was: {}", (Object)randomValue);
                        }
                        UndeadNights.serverState.setSpawnZombies(true);
                        UndeadNights.serverState.setRespawnZombies(false);
                    } else {
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("RandomValue: {}", (Object)randomValue);
                        }
                        return 0;
                    }
                }
            }
            if (UndeadNights.serverState.getNightIsStarting() && UndeadNights.serverState.getDaysCounter() >= 1) {
                if (UndeadNights.serverState.getGracePeriod() > 0) {
                    UndeadNights.serverState.setGracePeriod(UndeadNights.serverState.getGracePeriod() - 1);
                    if (MainConfig.getSendHordeNightsCountdownMessage()) {
                        for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                            player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.days_of_grace_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getGracePeriod())}));
                        }
                    }
                    if (UndeadNights.serverState.getGracePeriod() == 0) {
                        UndeadNights.serverState.setDaysCounter(1);
                    } else {
                        return 0;
                    }
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.serverState.getDaysCounter() - 1);
                if (UndeadNights.serverState.getDaysCounter() > 0 && MainConfig.getSendHordeNightsCountdownMessage()) {
                    for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                        if (UndeadNights.serverState.getDaysCounter() > 1) {
                            player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.nights_remaining", (Object[])new Object[]{String.valueOf(UndeadNights.serverState.getDaysCounter())}));
                            continue;
                        }
                        player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.last_nights"));
                    }
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("Night is coming, NormalizedTimeOfDay: {}, TimeOfDay: {}, DaysCounter: {}, GameTime: {}, GameTimeDays: {}", new Object[]{normalizedTimeOfDay, level.getDayTime(), UndeadNights.serverState.getDaysCounter(), level.getGameTime(), level.getGameTime() / 24000L});
                }
            }
            if (UndeadNights.serverState.getDaysCounter() > 0 && !UndeadNights.serverState.getHordeNight() && !UndeadNights.serverState.isSpawnBossHorde()) {
                if (UndeadNights.serverState.getTryToSpawnRandomHorde()) {
                    if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().isEnableRandomHordes().booleanValue() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap() && (randomValue = randomSource.nextIntBetweenInclusive(1, 100)) > 100 - UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordes().getChanceForRandomHorde()) {
                        players = level.getPlayers(LivingEntity::isAlive).iterator();
                        while (players.hasNext() && this.spawnHorde(level, player2 = (ServerPlayer)players.next(), randomSource) != SpawnHordeResult.FAILED) {
                            if (!MainConfig.getPrintDebugMessages()) continue;
                            UndeadNights.LOGGER.info("A random horde has spawned!");
                        }
                    }
                    UndeadNights.serverState.setTryToSpawnRandomHorde(false);
                }
                if (MainConfig.getHordeZombiesSpawnNaturally() && UndeadNights.globalSpawnCounter < MainConfig.getHordeMobsSpawnCap() && !UndeadNights.serverState.isSpawnBossHorde()) {
                    if (UndeadNights.serverState.getTickCounter() > 0) {
                        UndeadNights.serverState.setTickCounter(UndeadNights.serverState.getTickCounter() - 1);
                        return 0;
                    }
                    UndeadNights.serverState.setTickCounter(100);
                    if (!(randomSource.nextFloat() < 0.03f)) {
                        return 0;
                    }
                    for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                        BlockPos pos = SpawnLocationFinder.getBlockPosWithDistance(player2.blockPosition(), (Level)level, MainConfig.getDistanceMin(), MainConfig.getDistanceMax());
                        if (!SpawnLocationFinder.checkSpawnLocation(level, pos.getX(), pos.getY() - 1, pos.getZ())) {
                            return 0;
                        }
                        SpawnProcess.spawnHordeMob(level, randomSource, pos, (Player)player2, new HordeConfig.MobSpawnData("undeadnights:horde_zombie", 100, 0, 0, UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getHordeMobsTrackingRange(), "none", ""));
                        if (!MainConfig.getPrintDebugMessages()) continue;
                        UndeadNights.LOGGER.info("A stray horde zombie spawned!");
                    }
                }
                return 0;
            }
            if (UndeadNights.serverState.getNightIsStarting()) {
                randomValue = randomSource.nextIntBetweenInclusive(1, 100);
                if (randomValue <= 100 - UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getChanceForHordeNight()) {
                    return 0;
                }
                UndeadNights.serverState.setIsNaturalSpawningOk(true);
                UndeadNights.serverState.setHordeNight(true);
                UndeadNights.serverState.setSpawnZombies(true);
                UndeadNights.serverState.setFirstWaveHasSpawned(false);
                for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                    player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_night").withStyle(ChatFormatting.RED));
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The coming night is a Horde Night, HordeNight: {}", (Object)UndeadNights.serverState.getHordeNight());
                }
            }
            if (UndeadNights.serverState.getSpawnZombies() && UndeadNights.serverState.getHordeNight() && (normalizedTimeOfDay >= 12542L || allDayLong)) {
                if (UndeadNights.serverState.getHordesCounter() != 0 && !UndeadNights.serverState.isSpawnBossHorde() && UndeadNights.serverState.getHordesCounter() - 1 == 0) {
                    return 0;
                }
                if (UndeadNights.serverState.isSpawnBossHorde()) {
                    return 0;
                }
                int playerWithHordes = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getNumberOfPlayersToGetHordePerHordeEvent();
                boolean allPlayersGetHordes = playerWithHordes == 0;
                List players2 = level.getPlayers(LivingEntity::isAlive);
                Collections.shuffle(players2);
                for (ServerPlayer player3 : players2) {
                    if (!allPlayersGetHordes) {
                        if (playerWithHordes == 0) break;
                        --playerWithHordes;
                    }
                    UndeadNights.serverState.entitiesWithPendingHorde.add(player3.getUUID());
                    UndeadNights.serverState.entitiesWithPendingWave.add(player3.getUUID());
                    UndeadNights.serverState.entitiesWithReceivedHorde.remove(player3.getUUID());
                    UndeadNights.serverState.setFirstWaveHasSpawned(true);
                }
                UndeadNights.serverState.setHordesCounter(UndeadNights.serverState.getHordesCounter() - 1);
                if (!UndeadNights.serverState.getFirstWaveHasSpawned()) {
                    UndeadNights.serverState.setTickCounter(200);
                } else {
                    UndeadNights.serverState.setTickCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getCooldownBetweenWaves() * 20);
                    UndeadNights.serverState.setSpawnZombies(false);
                    UndeadNights.serverState.setRespawnZombies(true);
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Spawned waves for every player: DaysCounter: {} GlobalSpawnCounter: {} Spawn: {}, respawn: {}", new Object[]{UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter, UndeadNights.serverState.getSpawnZombies(), UndeadNights.serverState.getRespawnZombies()});
                    }
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
            }
        } else {
            UndeadNights.serverState.setSpawnBossHorde(false);
            if (UndeadNights.serverState.getHordeNight()) {
                for (ServerPlayer player2 : level.getPlayers(LivingEntity::isAlive)) {
                    if (!UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getAllDayLongHordeNights().booleanValue()) {
                        player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_night_over"));
                    } else {
                        player2.sendSystemMessage((Component)Component.translatable((String)"message.undeadnights.horde_time_over"));
                    }
                    if (!UndeadNights.serverState.entitiesWithPendingWave.contains(player2.getUUID())) continue;
                    UndeadNights.serverState.entitiesWithPendingWave.remove(player2.getUUID());
                    UndeadNights.serverState.entitiesWithPendingHorde.remove(player2.getUUID());
                }
                UndeadNights.serverState.setDaysCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
                if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() != 0) {
                    UndeadNights.serverState.setHordesCounter(UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() + 1);
                } else {
                    UndeadNights.serverState.setHordesCounter(0);
                }
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("The Night of the Undead is over, TimeOfDay: {} DaysCounter: {} GlobalSpawnCounter: {}", new Object[]{level.getDayTime(), UndeadNights.serverState.getDaysCounter(), UndeadNights.globalSpawnCounter});
                }
                randomValue = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getAllDayLongHordeNights() != false ? randomSource.nextIntBetweenInclusive(10000, 10500) : randomSource.nextIntBetweenInclusive(21500, 22000);
                bossHordeTime = randomValue;
            }
            if (normalizedTimeOfDay >= 11500L && !level.getPlayers(LivingEntity::isAlive).isEmpty() && UndeadNights.automaticDifficultyProgressionActive) {
                boolean flag = false;
                if (UndeadNights.serverState.isPerformDifficultySwitchCheck()) {
                    flag = UndeadNights.difficultyConfig.checkForDifficultyLevelSwitch((int)(level.getDayTime() / 24000L) + 1, randomSource);
                    UndeadNights.serverState.setPerformDifficultySwitchCheck(false);
                }
                if ((flag || !UndeadNights.serverState.isFirstDifficultyLevelPrinted()) && UndeadNights.difficultyConfig.getDifficultyLevels().size() > 1) {
                    for (ServerPlayer player4 : level.getPlayers(LivingEntity::isAlive)) {
                        player4.sendSystemMessage((Component)Component.literal((String)UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultyName()).withStyle(ChatFormatting.YELLOW));
                    }
                    if (MainConfig.getPrintDebugMessages()) {
                        UndeadNights.LOGGER.info("Difficulty level set to {}", (Object)UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultyName());
                    }
                    UndeadNights.serverState.setPossibleHordesIndex(-1);
                    UndeadNights.serverState.setFirstDifficultyLevelPrinted(true);
                }
            }
            UndeadNights.serverState.setHordeNight(false);
            UndeadNights.serverState.setSpawnZombies(true);
            UndeadNights.serverState.setRespawnZombies(false);
            UndeadNights.serverState.setTryToSpawnRandomHorde(true);
        }
        return 0;
    }

    public static class HordeSpawnTask {
        public CompletableFuture<SpawnHordeResult> futureResult;
        public int tries = 0;

        public HordeSpawnTask(CompletableFuture<SpawnHordeResult> futureResult, int tries) {
            this.futureResult = futureResult;
            this.tries = tries;
        }
    }

    public static enum SpawnHordeResult {
        DONE,
        NOT_DONE_YET,
        FAILED;

    }
}

