/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.util;

import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.util.GroundPathNavigationLegacy;
import net.petemc.undeadnights.util.RandomExtention;

public class SpawnLocationFinder {
    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor level, BlockPos pos) {
        return level.getBrightness(LightLayer.BLOCK, pos) <= MainConfig.getMaxBlockLightLevelForMonsterSpawns();
    }

    public static boolean checkSpawnLocation(ServerLevel level, double x, double y, double z) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, y, z);
        BlockState blockState = level.getBlockState((BlockPos)mutable);
        Block block = blockState.getBlock();
        boolean doesNotBlockMovement = block != Blocks.COBWEB && block != Blocks.BAMBOO_SAPLING;
        boolean notWater = true;
        boolean darkEnough = true;
        if (!MainConfig.getHordeWavesCanSpawnInWater()) {
            notWater = !blockState.getFluidState().is(FluidTags.WATER);
        }
        boolean notLeaves = true;
        if (!MainConfig.getHordeWavesCanSpawnOnTrees()) {
            boolean bl = notLeaves = !(blockState.getBlock() instanceof LeavesBlock);
        }
        if (MainConfig.getBlockLightLevelsInfluenceMonsterSpawns()) {
            darkEnough = SpawnLocationFinder.isDarkEnoughToSpawn((ServerLevelAccessor)level, (BlockPos)mutable);
        }
        return doesNotBlockMovement && notLeaves && notWater && darkEnough;
    }

    public static BlockPos getBlockPosWithDistance(BlockPos pos, Level level, int distanceMin, int distanceMax) {
        double _z;
        RandomSource random = level.random;
        double _d = random.nextIntBetweenInclusive(distanceMin, distanceMax);
        double _x = random.nextIntBetweenInclusive(0, (int)_d);
        if (_x == 0.0) {
            _z = _d;
        } else {
            _z = Math.sqrt(_d * _d - _x * _x);
            if (random.nextBoolean()) {
                _x *= -1.0;
            }
        }
        if (random.nextBoolean()) {
            _z *= -1.0;
        }
        return new BlockPos(pos.getX() + (int)_x, level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + (int)_x, pos.getZ() + (int)_z), pos.getZ() + (int)_z);
    }

    public static BlockPos findNearbySurfaceSpawnPosition(ServerLevel level, BlockPos pos, RandomExtention randomSource, boolean playerInCave) {
        int deltaX = randomSource.nextInt(5);
        int deltaZ = randomSource.nextInt(5);
        if (!randomSource.nextBoolean()) {
            deltaX *= -1;
        }
        if (!randomSource.nextBoolean()) {
            deltaZ *= -1;
        }
        int y = MainConfig.getHordeWavesCanSpawnOnTrees() ? level.getHeight(Heightmap.Types.MOTION_BLOCKING, pos.getX() + deltaX, pos.getZ() + deltaZ) : level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos.getX() + deltaX, pos.getZ() + deltaZ);
        return new BlockPos(pos.getX() + deltaX, y, pos.getZ() + deltaZ);
    }

    public static BlockPos findEndPositionUsingMinecraftPathfinding(Level level, ServerPlayer player, int distance, boolean allowEndInWater) {
        if (level == null || player == null || distance <= 0) {
            return null;
        }
        boolean debug = MainConfig.getPrintDebugMessages();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        int attempts = 600;
        int maxYDelta = 8;
        BlockPos start = player.blockPosition();
        if (!SpawnLocationFinder.isAABBFree(level, new AABB((double)start.getX() + 0.5 - 0.3, (double)start.getY(), (double)start.getZ() + 0.5 - 0.3, (double)start.getX() + 0.5 + 0.3, (double)start.getY() + 1.8, (double)start.getZ() + 0.5 + 0.3))) {
            if (debug) {
                UndeadNights.LOGGER.info("findEndUsingMinecraftPF: start pos AABB not free: {}", (Object)start);
            }
            return null;
        }
        HordeZombieEntity probe = new HordeZombieEntity(ModEntities.HORDE_ZOMBIE.get(), level);
        probe.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(start), MobSpawnType.MOB_SUMMONED, null);
        probe.setTarget((LivingEntity)player);
        level.addFreshEntity((Entity)probe);
        for (int i = 0; i < 600; ++i) {
            int dx = rnd.nextInt(-distance - 3, distance + 4);
            int dz = rnd.nextInt(-distance - 3, distance + 4);
            int cheb = Math.max(Math.abs(dx), Math.abs(dz));
            if (Math.abs(cheb - distance) > 4) continue;
            int cx = start.getX() + dx;
            int cz = start.getZ() + dz;
            int baseY = start.getY();
            for (int dy = -8; dy <= 8; ++dy) {
                int cy = baseY + dy;
                BlockPos cand = new BlockPos(cx, cy, cz);
                BlockState feet = level.getBlockState(cand);
                if (feet.is(Blocks.LAVA) || feet.getFluidState().is(FluidTags.LAVA) || !allowEndInWater && (feet.is(Blocks.WATER) || feet.getFluidState().is(FluidTags.WATER)) || MainConfig.getBlockLightLevelsInfluenceMonsterSpawns() && !SpawnLocationFinder.isDarkEnoughToSpawn((ServerLevelAccessor)level, cand) || !SpawnLocationFinder.hasSolidBlockBelow(level, cand) || !SpawnLocationFinder.isAABBFreeForSpawn(level, new AABB((double)cand.getX() + 0.5 - 0.3, (double)cand.getY() + 0.001, (double)cand.getZ() + 0.5 - 0.3, (double)cand.getX() + 0.5 + 0.3, (double)cand.getY() + 1.8 - 0.001, (double)cand.getZ() + 0.5 + 0.3))) continue;
                try {
                    probe.setOnGround(true);
                    probe.setPos((double)cand.getX() + 0.5, cand.getY(), (double)cand.getZ() + 0.5);
                    GroundPathNavigationLegacy nav = new GroundPathNavigationLegacy((Mob)probe, level);
                    Path path = nav.createPathLegacy((Entity)player, 0);
                    if (path != null) {
                        if (debug) {
                            UndeadNights.LOGGER.info("findEndUsingMinecraftPF: candidate {} accepted by vanilla navigation (attempt {})", (Object)cand, (Object)i);
                        }
                        probe.remove(Entity.RemovalReason.DISCARDED);
                        return cand;
                    }
                    if (!debug) continue;
                    UndeadNights.LOGGER.info("findEndUsingMinecraftPF: candidate {} rejected by vanilla navigation (null/empty)", (Object)cand);
                    continue;
                }
                catch (Throwable t) {
                    UndeadNights.LOGGER.warn("findEndUsingMinecraftPF: navigation threw for candidate {}: {}", (Object)cand, (Object)t.toString());
                }
            }
        }
        probe.remove(Entity.RemovalReason.DISCARDED);
        if (debug) {
            UndeadNights.LOGGER.info("findEndUsingMinecraftPF: no candidate found (distance={})", (Object)distance);
        }
        return null;
    }

    private static boolean isAABBFree(Level level, AABB box) {
        int minX = (int)Math.floor(box.minX);
        int minY = (int)Math.floor(box.minY);
        int minZ = (int)Math.floor(box.minZ);
        int maxX = (int)Math.floor(box.maxX);
        int maxY = (int)Math.floor(box.maxY);
        int maxZ = (int)Math.floor(box.maxZ);
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BlockPos bpos = new BlockPos(bx, by, bz);
                    BlockState state = level.getBlockState(bpos);
                    VoxelShape shape = state.getCollisionShape((BlockGetter)level, bpos);
                    if (shape.isEmpty() || state.getBlock() instanceof FenceBlock || state.getBlock() instanceof FenceGateBlock || state.getBlock() instanceof DoorBlock) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean hasSolidBlockBelow(Level level, BlockPos center) {
        BlockPos below = center.below();
        if (below.getY() < level.getMinBuildHeight()) {
            return false;
        }
        BlockState belowState = level.getBlockState(below);
        boolean hasCollision = !belowState.getCollisionShape((BlockGetter)level, below).isEmpty();
        boolean isSlab = belowState.is(BlockTags.SLABS);
        boolean isStair = belowState.is(BlockTags.STAIRS);
        boolean isFence = belowState.getBlock() instanceof FenceBlock;
        boolean isFenceGate = belowState.getBlock() instanceof FenceGateBlock;
        boolean isDoor = belowState.getBlock() instanceof DoorBlock;
        return hasCollision || isSlab || isStair || isFence || isFenceGate || isDoor;
    }

    private static boolean isAABBFreeForSpawn(Level level, AABB box) {
        int minX = (int)Math.floor(box.minX);
        int minY = (int)Math.floor(box.minY);
        int minZ = (int)Math.floor(box.minZ);
        int maxX = (int)Math.floor(box.maxX);
        int maxY = (int)Math.floor(box.maxY);
        int maxZ = (int)Math.floor(box.maxZ);
        for (int bx = minX; bx <= maxX; ++bx) {
            for (int by = minY; by <= maxY; ++by) {
                for (int bz = minZ; bz <= maxZ; ++bz) {
                    BlockPos bpos = new BlockPos(bx, by, bz);
                    BlockState state = level.getBlockState(bpos);
                    VoxelShape shape = state.getCollisionShape((BlockGetter)level, bpos);
                    if (shape.isEmpty()) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static BlockPos findSpawnablePosition(Level level, BlockPos center, int radius, int deltaY) {
        int dx;
        if (level == null || center == null) {
            return null;
        }
        int minY = level.getMinBuildHeight();
        int maxY = level.getMaxBuildHeight() - 1;
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        float mobWidth = 0.6f;
        float mobHeight = 1.8f;
        boolean allowWater = MainConfig.getHordeWavesCanSpawnInWater();
        int attempts = 200;
        for (int i = 0; i < 200; ++i) {
            BlockPos cand;
            BlockState feet;
            dx = rnd.nextInt(-radius, radius + 1);
            int dz = rnd.nextInt(-radius, radius + 1);
            int dy = deltaY > 0 ? rnd.nextInt(-deltaY, deltaY + 1) : 0;
            int x = center.getX() + dx;
            int z = center.getZ() + dz;
            int y = center.getY() + dy;
            if (y < minY || y > maxY || (feet = level.getBlockState(cand = new BlockPos(x, y, z))).is(Blocks.LAVA) || feet.getFluidState().is(FluidTags.LAVA) || !SpawnLocationFinder.isValidSpawnPos(level, cand, 0.6f, 1.8f, allowWater)) continue;
            return cand;
        }
        for (int r = 0; r <= radius; ++r) {
            for (dx = -r; dx <= r; ++dx) {
                int[] zs;
                int[] nArray;
                if (r == 0) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 0;
                } else {
                    int[] nArray3 = new int[2];
                    nArray3[0] = -r;
                    nArray = nArray3;
                    nArray3[1] = r;
                }
                for (int zOff : zs = nArray) {
                    int x = center.getX() + dx;
                    int z = center.getZ() + zOff;
                    for (int dy = -deltaY; dy <= deltaY; ++dy) {
                        BlockPos cand;
                        BlockState feet;
                        int y = center.getY() + dy;
                        if (y < minY || y > maxY || (feet = level.getBlockState(cand = new BlockPos(x, y, z))).is(Blocks.LAVA) || feet.getFluidState().is(FluidTags.LAVA) || !SpawnLocationFinder.isValidSpawnPos(level, cand, 0.6f, 1.8f, allowWater)) continue;
                        return cand;
                    }
                }
            }
        }
        return null;
    }

    private static boolean isValidSpawnPos(Level level, BlockPos pos, float mobWidth, float mobHeight, boolean allowWater) {
        boolean feetIsLava;
        if (level == null || pos == null) {
            return false;
        }
        int minY = level.getMinBuildHeight();
        int maxY = level.getMaxBuildHeight();
        if (pos.getY() < minY || pos.getY() >= maxY) {
            return false;
        }
        BlockState feetState = level.getBlockState(pos);
        boolean feetIsWater = feetState.is(Blocks.WATER) || feetState.getFluidState().is(FluidTags.WATER);
        boolean bl = feetIsLava = feetState.is(Blocks.LAVA) || feetState.getFluidState().is(FluidTags.LAVA);
        if (feetIsLava) {
            return false;
        }
        if (feetIsWater && !allowWater) {
            return false;
        }
        VoxelShape feetShape = feetState.getCollisionShape((BlockGetter)level, pos);
        if (!feetShape.isEmpty() && !feetIsWater) {
            return false;
        }
        double cx = (double)pos.getX() + 0.5;
        double cz = (double)pos.getZ() + 0.5;
        double bottomY = pos.getY();
        double topY = bottomY + (double)mobHeight;
        double halfWidth = (double)mobWidth / 2.0;
        double eps = 0.001;
        AABB box = new AABB(cx - halfWidth + 0.001, bottomY + 0.001, cz - halfWidth + 0.001, cx + halfWidth - 0.001, topY - 0.001, cz + halfWidth - 0.001);
        if (!SpawnLocationFinder.isAABBFreeForSpawn(level, box)) {
            return false;
        }
        if (!allowWater) {
            int bottomBlock = (int)Math.floor(box.minY);
            int topBlock = (int)Math.floor(box.maxY);
            for (int by = bottomBlock; by <= topBlock; ++by) {
                BlockState s = level.getBlockState(new BlockPos(pos.getX(), by, pos.getZ()));
                if (!s.is(Blocks.WATER) && !s.getFluidState().is(FluidTags.WATER)) continue;
                return false;
            }
        }
        return SpawnLocationFinder.hasSolidBlockBelow(level, pos);
    }
}

