/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class GroundPathNavigationLegacy
extends PathNavigation {
    private boolean avoidSun;

    public GroundPathNavigationLegacy(Mob mob, Level level) {
        super(mob, level);
    }

    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new PathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected boolean canUpdatePath() {
        return this.mob.onGround() || this.mob.isInLiquid() || this.mob.isPassenger();
    }

    protected Vec3 getTempMobPos() {
        return new Vec3(this.mob.getX(), (double)this.getSurfaceY(), this.mob.getZ());
    }

    public Path createPathLegacy(BlockPos pPos, int pAccuracy) {
        if (this.level.getBlockState(pPos).isAir()) {
            BlockPos blockpos = pPos.below();
            while (blockpos.getY() > this.level.getMinBuildHeight() && this.level.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.below();
            }
            if (blockpos.getY() > this.level.getMinBuildHeight()) {
                return super.createPath(blockpos.above(), pAccuracy);
            }
            while (blockpos.getY() < this.level.getMaxBuildHeight() && this.level.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.above();
            }
            pPos = blockpos;
        }
        if (!this.level.getBlockState(pPos).isSolid()) {
            return super.createPath(pPos, pAccuracy);
        }
        BlockPos blockpos1 = pPos.above();
        while (blockpos1.getY() < this.level.getMaxBuildHeight() && this.level.getBlockState(blockpos1).isSolid()) {
            blockpos1 = blockpos1.above();
        }
        return super.createPath(blockpos1, pAccuracy);
    }

    public Path createPathLegacy(Entity pEntity, int pAccuracy) {
        return this.createPathLegacy(pEntity.blockPosition(), pAccuracy);
    }

    public Path createPath(BlockPos pos, int accuracy) {
        LevelChunk levelchunk = this.level.getChunkSource().getChunkNow(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        if (levelchunk == null) {
            return null;
        }
        if (levelchunk.getBlockState(pos).isAir()) {
            BlockPos blockpos = pos.below();
            while (blockpos.getY() > this.level.getMinBuildHeight() && levelchunk.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.below();
            }
            if (blockpos.getY() > this.level.getMinBuildHeight()) {
                return super.createPath(blockpos.above(), accuracy);
            }
            while (blockpos.getY() < this.level.getMaxBuildHeight() && levelchunk.getBlockState(blockpos).isAir()) {
                blockpos = blockpos.above();
            }
            pos = blockpos;
        }
        if (!levelchunk.getBlockState(pos).isSolid()) {
            return super.createPath(pos, accuracy);
        }
        BlockPos blockpos1 = pos.above();
        while (blockpos1.getY() < this.level.getMaxBuildHeight() && levelchunk.getBlockState(blockpos1).isSolid()) {
            blockpos1 = blockpos1.above();
        }
        return super.createPath(blockpos1, accuracy);
    }

    public Path createPath(Entity entity, int accuracy) {
        return this.createPath(entity.blockPosition(), accuracy);
    }

    private int getSurfaceY() {
        if (this.mob.isInWater() && this.canFloat()) {
            int i = this.mob.getBlockY();
            BlockState blockstate = this.level.getBlockState(BlockPos.containing((double)this.mob.getX(), (double)i, (double)this.mob.getZ()));
            int j = 0;
            while (blockstate.is(Blocks.WATER)) {
                Level var10000 = this.level;
                double var10001 = this.mob.getX();
                blockstate = var10000.getBlockState(BlockPos.containing((double)var10001, (double)(++i), (double)this.mob.getZ()));
                if (++j <= 16) continue;
                return this.mob.getBlockY();
            }
            return i;
        }
        return Mth.floor((double)(this.mob.getY() + 0.5));
    }

    protected void trimPath() {
        super.trimPath();
        if (this.avoidSun) {
            if (this.level.canSeeSky(BlockPos.containing((double)this.mob.getX(), (double)(this.mob.getY() + 0.5), (double)this.mob.getZ()))) {
                return;
            }
            for (int i = 0; i < this.path.getNodeCount(); ++i) {
                Node node = this.path.getNode(i);
                if (!this.level.canSeeSky(new BlockPos(node.x, node.y, node.z))) continue;
                this.path.truncateNodes(i);
                return;
            }
        }
    }

    protected boolean hasValidPathType(PathType pathType) {
        if (pathType == PathType.WATER) {
            return false;
        }
        return pathType == PathType.LAVA ? false : pathType != PathType.OPEN;
    }

    public void setCanOpenDoors(boolean canOpenDoors) {
        this.nodeEvaluator.setCanOpenDoors(canOpenDoors);
    }

    public boolean canPassDoors() {
        return this.nodeEvaluator.canPassDoors();
    }

    public void setCanPassDoors(boolean canPassDoors) {
        this.nodeEvaluator.setCanPassDoors(canPassDoors);
    }

    public boolean canOpenDoors() {
        return this.nodeEvaluator.canPassDoors();
    }

    public void setAvoidSun(boolean avoidSun) {
        this.avoidSun = avoidSun;
    }

    public void setCanWalkOverFences(boolean canWalkOverFences) {
        this.nodeEvaluator.setCanWalkOverFences(canWalkOverFences);
    }
}

