/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.mixin;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.petemc.undeadnights.casts.UndeadNightsExtendedPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerEntityMixin
implements UndeadNightsExtendedPlayer {
    @Unique
    private boolean hasHordeLureEffect = false;
    @Unique
    private boolean isInCave = false;
    @Unique
    private boolean isInCaveStageOne = false;
    @Unique
    private boolean previousIsInCaveStageOne = false;
    @Unique
    private boolean isInCaveStageTwo = false;
    @Unique
    private boolean previousIsInCaveStageTwo = false;
    @Unique
    private int coolDown = 100;
    @Unique
    private int delay = 3;

    @Override
    public void undeadnights_setHordeLureEffect(boolean hordeLureValue) {
        this.hasHordeLureEffect = hordeLureValue;
    }

    @Override
    public boolean undeadnights_hasHordeLureEffect() {
        return this.hasHordeLureEffect;
    }

    @Override
    public void undeadnights_setIsInCave(boolean isInCaveValue) {
        this.isInCave = isInCaveValue;
    }

    @Override
    public boolean undeadnights_isInCave() {
        return this.isInCave;
    }

    @Override
    public boolean undeadnights_isInCaveDelayed() {
        return this.isInCaveStageOne;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;updatePlayerPose()V", shift=At.Shift.AFTER)})
    public void tick(CallbackInfo ci) {
        Player player = (Player)this;
        if (!player.level().isClientSide()) {
            if (this.coolDown > 0) {
                --this.coolDown;
            } else {
                this.coolDown = 100;
                this.isInCaveStageOne = PlayerEntityMixin.caveCheckStageOne(player.level(), player.blockPosition());
                if (this.isInCaveStageOne) {
                    if (this.delay > 0) {
                        --this.delay;
                    } else {
                        this.delay = 3;
                        this.isInCaveStageTwo = PlayerEntityMixin.caveCheckStageTwo(player.level(), player.blockPosition());
                        if (this.isInCaveStageTwo) {
                            this.undeadnights_setIsInCave(true);
                        }
                    }
                } else {
                    this.isInCaveStageTwo = false;
                    this.previousIsInCaveStageTwo = false;
                    this.undeadnights_setIsInCave(false);
                    this.delay = 3;
                }
                if (this.previousIsInCaveStageOne != this.isInCaveStageOne) {
                    this.previousIsInCaveStageOne = this.isInCaveStageOne;
                }
                if (this.isInCaveStageTwo != this.previousIsInCaveStageTwo) {
                    this.previousIsInCaveStageTwo = this.isInCaveStageTwo;
                }
            }
        }
    }

    @Unique
    private static boolean caveCheckStageOne(Level level, BlockPos pos) {
        int z;
        int layersAbove = 0;
        int x = pos.getX();
        int y = level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z = pos.getZ());
        if (y == pos.getY()) {
            return false;
        }
        y = level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z);
        if (y == pos.getY()) {
            return false;
        }
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos(x, pos.getY() + 1, z);
        while (checkPos.getY() < y) {
            BlockState state = level.getBlockState((BlockPos)checkPos);
            if (state.isAir()) {
                layersAbove = 0;
                checkPos.move(0, 1, 0);
                continue;
            }
            if (state.is(Blocks.WATER)) {
                layersAbove = 0;
                checkPos.move(0, 1, 0);
                continue;
            }
            if (state.is(Blocks.DEEPSLATE) && checkPos.getY() > 8) {
                layersAbove = 0;
                checkPos.move(0, 1, 0);
                continue;
            }
            if (state.is(Blocks.COBBLESTONE)) {
                layersAbove = 0;
                checkPos.move(0, 1, 0);
                continue;
            }
            if (state.is(BlockTags.LEAVES)) {
                layersAbove = 0;
                checkPos.move(0, 1, 0);
                continue;
            }
            if (++layersAbove > 3) {
                return true;
            }
            checkPos.move(0, 1, 0);
        }
        return false;
    }

    @Unique
    private static boolean caveCheckStageTwo(Level level, BlockPos pos) {
        AABB box = new AABB(pos).inflate(10.0, 0.0, 10.0);
        AtomicBoolean isCave = new AtomicBoolean(true);
        BlockPos.MutableBlockPos.betweenClosedStream((AABB)box).forEach(c -> {
            int y1 = level.getHeight(Heightmap.Types.MOTION_BLOCKING, c.getX(), c.getZ());
            if (c.getY() + 5 >= y1) {
                isCave.set(false);
            }
        });
        return isCave.get();
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectToReadNbt(CompoundTag nbt, CallbackInfo ci) {
        this.isInCave = nbt.getBoolean("undeadnights_is_player_in_cave");
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void injectToWriteNbt(CompoundTag nbt, CallbackInfo ci) {
        nbt.putBoolean("undeadnights_is_player_in_cave", this.isInCave);
    }
}

