/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Comparator;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.brewing.RegisterBrewingRecipesEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.player.CanPlayerSleepEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.server.command.ConfigCommand;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.casts.BlockBreakingZombie;
import net.petemc.undeadnights.command.DifficultyLevelCommand;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.command.SetDefaultHordeCommand;
import net.petemc.undeadnights.command.SpawnHordeCommand;
import net.petemc.undeadnights.command.StatusCommand;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.DemolitionZombieEntity;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ai.goal.BreakBlockGoal;
import net.petemc.undeadnights.item.ModItems;
import net.petemc.undeadnights.potion.ModPotions;
import net.petemc.undeadnights.util.ModTags;

@EventBusSubscriber(modid="undeadnights", bus=EventBusSubscriber.Bus.GAME)
public class GameEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (!event.getLevel().isClientSide() && UndeadNights.serverState != null && UndeadNights.serverState.spawnedHordeMobs.contains(event.getEntity().getUUID())) {
            if (UndeadNights.serverState.hordeMobsToRemove.contains(event.getEntity().getUUID())) {
                UndeadNights.serverState.hordeMobsToRemove.remove(event.getEntity().getUUID());
                event.getEntity().remove(Entity.RemovalReason.DISCARDED);
                event.setCanceled(true);
                if (MainConfig.getPrintDebugMessages()) {
                    UndeadNights.LOGGER.info("LOAD canceled, Entity marked for removal: {}", (Object)event.getEntity().getUUID());
                }
            } else {
                ++UndeadNights.globalSpawnCounter;
                Entity entity = event.getEntity();
                if (entity instanceof Zombie) {
                    Zombie zombie = (Zombie)entity;
                    if (!(zombie instanceof HordeZombieEntity || zombie instanceof DemolitionZombieEntity || zombie instanceof EliteZombieEntity)) {
                        if (MainConfig.getPrintDebugMessages()) {
                            UndeadNights.LOGGER.info("Vanilla zombie detected, adding float and block breaking goals.");
                        }
                        zombie.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)zombie));
                        zombie.goalSelector.addGoal(1, (Goal)new BreakBlockGoal(zombie));
                    }
                    if (zombie instanceof EliteZombieEntity) {
                        UndeadNights.serverState.setFirstEliteZombieHasSpawned(true);
                    }
                    if (zombie instanceof DemolitionZombieEntity) {
                        UndeadNights.serverState.setFirstDemolitionZombieHasSpawned(true);
                    }
                }
            }
            if (MainConfig.getPrintDebugMessages()) {
                UndeadNights.LOGGER.info("LOAD GlobalSpawnCount: : {} {} {}", new Object[]{UndeadNights.globalSpawnCounter, event.getEntity().getName().getString(), event.getEntity().getUUID()});
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveWorld(EntityLeaveLevelEvent event) {
        if (!event.getLevel().isClientSide() && UndeadNights.serverState != null && UndeadNights.serverState.spawnedHordeMobs.contains(event.getEntity().getUUID()) && event.getEntity().getRemovalReason() != null && (event.getEntity().getRemovalReason() == Entity.RemovalReason.KILLED || event.getEntity().getRemovalReason() == Entity.RemovalReason.DISCARDED)) {
            --UndeadNights.globalSpawnCounter;
            UndeadNights.serverState.spawnedHordeMobs.remove(event.getEntity().getUUID());
            if (MainConfig.getPrintDebugMessages() && event.getEntity().getRemovalReason() != null) {
                UndeadNights.LOGGER.info("UNLOAD GlobalSpawnCount: {} {} {}", new Object[]{UndeadNights.globalSpawnCounter, event.getEntity().getRemovalReason().name(), event.getEntity().getUUID()});
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTrySleep(CanPlayerSleepEvent event) {
        if (UndeadNights.serverState.getHordeNight() && MainConfig.getHordeNightsDisableSleeping()) {
            event.setProblem(Player.BedSleepingProblem.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        new SpawnHordeCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new HordeMobsCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new StatusCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new SetDefaultHordeCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new DifficultyLevelCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onRegisterBrewingRecipes(RegisterBrewingRecipesEvent event) {
        PotionBrewing.Builder builder = event.getBuilder();
        builder.addMix(Potions.AWKWARD, (Item)ModItems.SLIMY_ROTTEN_FLESH.get(), ModPotions.LURE_HORDE_POTION);
        builder.addMix(ModPotions.LURE_HORDE_POTION, (Item)ModItems.SLIMY_ROTTEN_FLESH.get(), ModPotions.STRONG_LURE_HORDE_POTION);
    }

    @SubscribeEvent
    public static void onEntityTick(EntityTickEvent.Pre event) {
        Level world = event.getEntity().level();
        Entity entity = event.getEntity();
        if (entity.getType().is(ModTags.EntityTypes.HORDE_MOBS)) {
            BlockBreakingZombie blockBreakingZombie;
            EliteZombieEntity eliteZombieEntity;
            HordeZombieEntity hordeZombie;
            if (entity instanceof HordeZombieEntity && (hordeZombie = (HordeZombieEntity)entity).isBreakingBlock()) {
                return;
            }
            if (entity instanceof EliteZombieEntity && (eliteZombieEntity = (EliteZombieEntity)entity).isBreakingBlock()) {
                return;
            }
            if (entity instanceof BlockBreakingZombie && (blockBreakingZombie = (BlockBreakingZombie)entity).isBreakingBlock()) {
                return;
            }
            if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isHordeMobsCanClimbEachOther().booleanValue()) {
                Vec3 entityPosition = entity.position();
                AABB entitySearchArea = new AABB(entityPosition, entityPosition).inflate(0.225);
                List<Entity> sortedEntityList = world.getEntitiesOfClass(Entity.class, entitySearchArea, entityTagCheck -> entityTagCheck.getType().is(ModTags.EntityTypes.HORDE_MOBS)).stream().sorted(Comparator.comparingDouble(entityDistSort -> entityDistSort.distanceToSqr(entityPosition))).toList();
                for (Entity hordeMobIterator : sortedEntityList) {
                    if (entity.getX() == hordeMobIterator.getX()) continue;
                    double randomValue = Math.random();
                    if (randomValue > 0.16) {
                        randomValue = 0.16;
                    }
                    Vec3 entityVec3 = new Vec3(entity.getDeltaMovement().x() + randomValue / 20.0 * (double)Mth.nextInt((RandomSource)RandomSource.create(), (int)-1, (int)1), randomValue, entity.getDeltaMovement().z() + randomValue / 20.0 * (double)Mth.nextInt((RandomSource)RandomSource.create(), (int)-1, (int)1));
                    entity.setDeltaMovement(entityVec3);
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        if (livingEntity.isBaby()) {
                            entity.setDeltaMovement(entityVec3.add(0.0, randomValue, 0.0));
                        }
                        livingEntity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 5, 0, false, false));
                    }
                    entity.fallDistance = 0.0f;
                }
            }
        }
    }
}

