/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.entity;

import java.time.LocalDate;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.entity.EliteZombieEntity;
import net.petemc.undeadnights.entity.HordeZombieEntity;
import net.petemc.undeadnights.entity.ai.goal.TntIgniteAndThrowGoal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DemolitionZombieEntity
extends Zombie {
    private int numberTnt = 3;

    public DemolitionZombieEntity(EntityType<? extends Zombie> entityType, Level world) {
        super(entityType, world);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData) {
        boolean flag;
        spawnGroupData = super.finalizeSpawn(level, difficulty, mobSpawnType, spawnGroupData);
        float f = difficulty.getSpecialMultiplier();
        this.setCanPickUpLoot(this.random.nextFloat() < 0.55f * f);
        if (spawnGroupData == null) {
            spawnGroupData = new Zombie.ZombieGroupData(false, false);
        }
        if (spawnGroupData instanceof Zombie.ZombieGroupData) {
            this.setCanBreakDoors(true);
            this.populateDefaultEquipmentSlots(this.random, difficulty);
            this.populateDefaultEquipmentEnchantments(level, this.random, difficulty);
        }
        if (this.getItemBySlot(EquipmentSlot.HEAD).isEmpty()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.getDayOfMonth();
            int j = localdate.getMonth().getValue();
            if (j == 10 && i == 31 && this.random.nextFloat() < 0.25f) {
                this.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)(this.random.nextFloat() < 0.1f ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN)));
                this.armorDropChances[EquipmentSlot.HEAD.getIndex()] = 0.0f;
            }
        }
        Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_health_boost"), MainConfig.getMaxHealthDemolitionZombies() - 20.0, AttributeModifier.Operation.ADD_VALUE));
        if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isUpdateHordeMobAttributes().booleanValue()) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_health_bonus"), UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getHealthAttributeScaleFactor() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_speed_bonus"), UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getSpeedAttributeScaleFactor() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_attack_damage_bonus"), UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getDamageAttributeScaleFactor() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            Objects.requireNonNull(this.getAttribute(Attributes.ARMOR)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_armor_bonus"), UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getArmorAttributeScaleFactor() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        int playerCount = 1;
        if (!this.level().isClientSide) {
            playerCount = this.level().players().size();
        }
        double healthScaleFactor = 0.0;
        double damageScaleFactor = 0.0;
        double speedScaleFactor = 0.0;
        double armorScaleFactor = 0.0;
        if (UndeadNights.difficultyConfig.getDynamicScaling().isDynamicScalingEnabled().booleanValue()) {
            if (playerCount > 1) {
                healthScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getHealthScalePerPlayer() * (double)(playerCount - 1);
                speedScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getSpeedScalePerPlayer() * (double)(playerCount - 1);
                damageScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getDamageScalePerPlayer() * (double)(playerCount - 1);
                armorScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getArmorScalePerPlayer() * (double)(playerCount - 1);
            }
            healthScaleFactor += UndeadNights.serverState.getCurrentHealthScale();
            speedScaleFactor += UndeadNights.serverState.getCurrentSpeedScale();
            damageScaleFactor += (double)UndeadNights.serverState.getCurrentDayScaleCounter();
            armorScaleFactor += UndeadNights.serverState.getCurrentArmorScale();
            if (healthScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale()) {
                healthScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxHealthScale();
            }
            if (speedScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale()) {
                speedScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxSpeedScale();
            }
            if (damageScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale()) {
                damageScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxDamageScale();
            }
            if (armorScaleFactor > UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale()) {
                armorScaleFactor = UndeadNights.difficultyConfig.getDynamicScaling().getMaxArmorScale();
            }
        }
        boolean bl = flag = healthScaleFactor > 0.0 || speedScaleFactor > 0.0 || damageScaleFactor > 0.0 || armorScaleFactor > 0.0;
        if (flag) {
            Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_difficulty_health_bonus"), healthScaleFactor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            Objects.requireNonNull(this.getAttribute(Attributes.MOVEMENT_SPEED)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_difficulty_speed_bonus"), speedScaleFactor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_difficulty_attack_damage_bonus"), damageScaleFactor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
            Objects.requireNonNull(this.getAttribute(Attributes.ARMOR)).addPermanentModifier(new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"undeadnights", (String)"demolition_zombie_difficulty_armor_bonus"), armorScaleFactor, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
        this.handleAttributes(f);
        this.setHealth(this.getMaxHealth());
        this.setBaby(false);
        return spawnGroupData;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.FOLLOW_RANGE, UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getHordeMobsTrackingRange().doubleValue()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.ARMOR, 4.0).add(Attributes.SPAWN_REINFORCEMENTS_CHANCE, 0.0);
    }

    protected void addBehaviourGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TntIgniteAndThrowGoal(this));
        this.goalSelector.addGoal(3, (Goal)new ZombieAttackGoal((Zombie)this, 1.0, false));
        this.goalSelector.addGoal(4, (Goal)new ChasePlayerGoal(this));
        this.goalSelector.addGoal(6, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 1.0, true, 4, this::canBreakDoors));
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{HordeZombieEntity.class, EliteZombieEntity.class, DemolitionZombieEntity.class}).setAlertOthers(new Class[]{HordeZombieEntity.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, true, entity -> HordeConfig.getTargetEntities().contains(entity.getType().toString())));
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel pLevel, @NotNull DamageSource pDamageSource, boolean pRecentlyHit) {
        super.dropCustomDeathLoot(pLevel, pDamageSource, pRecentlyHit);
        this.dropInventory();
    }

    public void dropInventory() {
        if (!this.getMainHandItem().isEmpty()) {
            this.spawnAtLocation(this.getMainHandItem());
            this.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
        }
    }

    protected void populateDefaultEquipmentSlots(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        if (this.numberTnt == 0) {
            this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.TNT));
        }
        if (this.numberTnt > 0 && this.numberTnt <= 64) {
            this.setItemInHand(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.TNT, this.numberTnt));
        }
        this.initCustomEquipment(pRandom, pDifficulty);
    }

    protected void initCustomEquipment(@NotNull RandomSource pRandom, @NotNull DifficultyInstance pDifficulty) {
        if (pRandom.nextFloat() < 0.15f * pDifficulty.getSpecialMultiplier()) {
            float f;
            int i = pRandom.nextInt(2);
            float f2 = f = this.level().getDifficulty() == Difficulty.HARD ? 0.1f : 0.25f;
            if (pRandom.nextFloat() < 0.095f) {
                ++i;
            }
            if (pRandom.nextFloat() < 0.095f) {
                ++i;
            }
            if (pRandom.nextFloat() < 0.095f) {
                ++i;
            }
            boolean flag = true;
            for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                Item item;
                if (equipmentslot.getType() != EquipmentSlot.Type.HUMANOID_ARMOR) continue;
                ItemStack itemstack = this.getItemBySlot(equipmentslot);
                if (!flag && pRandom.nextFloat() < f) break;
                flag = false;
                if (!itemstack.isEmpty() || (item = DemolitionZombieEntity.getEquipmentForSlot((EquipmentSlot)equipmentslot, (int)i)) == null) continue;
                this.setItemSlot(equipmentslot, new ItemStack((ItemLike)item));
            }
        }
    }

    protected boolean convertsInWater() {
        return false;
    }

    protected boolean isSunSensitive() {
        return UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isHordeZombiesBurnInTheSun();
    }

    public boolean canBreakDoors() {
        return true;
    }

    protected float getWaterSlowDown() {
        return UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isHordeZombiesAreFasterOnWater() != false ? 0.94f : 0.8f;
    }

    public void randomizeReinforcementsChance() {
        Objects.requireNonNull(this.getAttribute(Attributes.SPAWN_REINFORCEMENTS_CHANCE)).setBaseValue(0.0);
    }

    public boolean hurt(@NotNull DamageSource pSource, float pAmount) {
        if (this.isOnFire()) {
            Level level = this.level();
            BlockPos pos = this.blockPosition();
            this.remove(Entity.RemovalReason.KILLED);
            level.explode((Entity)this, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 5.0f, true, Level.ExplosionInteraction.TNT);
            return true;
        }
        return super.hurt(pSource, pAmount);
    }

    public void setNumberTnt(int value) {
        this.numberTnt = value;
    }

    public int getNumberTnt() {
        return this.numberTnt;
    }

    public static boolean checkDemolitionZombieSpawnRules(EntityType<DemolitionZombieEntity> demolitionZombieEntityType, ServerLevelAccessor serverLevel, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return MainConfig.getDemolitionZombiesSpawnNaturally() && UndeadNights.serverState.getIsNaturalSpawningOk() && !serverLevel.getBiome(pos).is(Biomes.MUSHROOM_FIELDS) && serverLevel.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)serverLevel, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules(demolitionZombieEntityType, (LevelAccessor)serverLevel, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public void push(Entity entity) {
        super.push(entity);
    }

    static class ChasePlayerGoal
    extends Goal {
        private final DemolitionZombieEntity demolitionZombie;
        @Nullable
        private LivingEntity target;

        public ChasePlayerGoal(DemolitionZombieEntity demolitionZombie) {
            this.demolitionZombie = demolitionZombie;
        }

        public boolean canUse() {
            this.target = this.demolitionZombie.getTarget();
            return this.target instanceof Player;
        }

        public void start() {
            this.demolitionZombie.getNavigation().stop();
        }

        public void tick() {
            assert (this.target != null);
            this.demolitionZombie.getLookControl().setLookAt(this.target.getX(), this.target.getEyeY(), this.target.getZ());
        }
    }
}

