/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.effect;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.casts.UndeadNightsExtendedPlayer;
import org.jetbrains.annotations.NotNull;

public class LureHordeMobsEffect
extends MobEffect {
    private static final HashMap<UUID, CompletableFuture<Boolean>> cachedNearbyHordeMobsPerPlayer = new HashMap();

    public static CompletableFuture<Boolean> asynchronousSetPlayerAsTargetForNearbyHordeMobs(ServerLevel level, ServerPlayer player) {
        return CompletableFuture.supplyAsync(() -> LureHordeMobsEffect.setPlayerAsTargetForNearbyHordeMobs(level, player), ForkJoinPool.commonPool());
    }

    private static Boolean setPlayerAsTargetForNearbyHordeMobs(ServerLevel level, ServerPlayer pPlayer) {
        Vec3 entityPosition = pPlayer.position();
        AABB entitySearchArea = new AABB(entityPosition, entityPosition).inflate(15.0);
        List<Entity> sortedEntityList = level.getEntitiesOfClass(Entity.class, entitySearchArea, entityUUIDCheck -> UndeadNights.serverState.spawnedHordeMobs.contains(entityUUIDCheck.getUUID())).stream().sorted(Comparator.comparingDouble(entityDistSort -> entityDistSort.distanceToSqr(entityPosition))).toList();
        for (Entity hordeMobIterator : sortedEntityList) {
            if (!(hordeMobIterator instanceof Mob)) continue;
            Mob mob = (Mob)hordeMobIterator;
            mob.setTarget((LivingEntity)pPlayer);
        }
        return true;
    }

    public LureHordeMobsEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public boolean applyEffectTick(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        if (!pLivingEntity.level().isClientSide()) {
            double chance = 0.08;
            if (pLivingEntity instanceof UndeadNightsExtendedPlayer) {
                UndeadNightsExtendedPlayer hordeLurePlayer = (UndeadNightsExtendedPlayer)pLivingEntity;
                if (!hordeLurePlayer.undeadnights_hasHordeLureEffect()) {
                    chance = 20.0;
                }
                hordeLurePlayer.undeadnights_setHordeLureEffect(true);
            }
            if (pLivingEntity instanceof Player) {
                double randomValue;
                Player pPlayer = (Player)pLivingEntity;
                Level world = pPlayer.level();
                RandomSource randomSource = pPlayer.getRandom();
                if (UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsLureEffect().isLureHordeEffectSpawnsHorde().booleanValue() && !UndeadNights.serverState.entitiesWithReceivedHorde.contains(pPlayer.getUUID())) {
                    if (randomSource.nextDouble() < UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsLureEffect().getChanceForLureEffectToSpawnHorde()) {
                        UndeadNights.serverState.entitiesWithPendingHorde.add(pPlayer.getUUID());
                    } else {
                        UndeadNights.serverState.entitiesWithReceivedHorde.add(pPlayer.getUUID());
                    }
                }
                if ((randomValue = Math.random()) < chance / 10.0) {
                    if (!cachedNearbyHordeMobsPerPlayer.containsKey(pPlayer.getUUID())) {
                        CompletableFuture<Boolean> future = LureHordeMobsEffect.asynchronousSetPlayerAsTargetForNearbyHordeMobs((ServerLevel)world, (ServerPlayer)pPlayer);
                        cachedNearbyHordeMobsPerPlayer.put(pPlayer.getUUID(), future);
                    } else {
                        CompletableFuture<Boolean> existingFuture = cachedNearbyHordeMobsPerPlayer.get(pPlayer.getUUID());
                        if (existingFuture.isDone()) {
                            cachedNearbyHordeMobsPerPlayer.remove(pPlayer.getUUID());
                        }
                    }
                }
            }
        }
        return super.applyEffectTick(pLivingEntity, pAmplifier);
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

