/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.world.spawner.HordeSpawner;

public class StatusCommand {
    public StatusCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").requires(source -> source.hasPermission(2))).then(Commands.literal((String)"status").executes(command -> this.status((CommandSourceStack)command.getSource()))));
    }

    private int status(CommandSourceStack source) throws CommandSyntaxException {
        ServerPlayer serverPlayer;
        String message = "DayCounter: " + UndeadNights.serverState.getDaysCounter() + " (max " + UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights() + ")\nGrace period: " + UndeadNights.serverState.getGracePeriod() + " (of " + MainConfig.getGracePeriodBeforeFirstHordeNight() + " days remaining)\nUndeadNights enabled: " + MainConfig.getUndeadNightsEnabled() + "\nIs it HordeNight: " + UndeadNights.serverState.getHordeNight() + "\nSpawnCounter: " + UndeadNights.globalSpawnCounter + " of max " + MainConfig.getHordeMobsSpawnCap() + "\nBlock breaking: " + (String)(HordeMobsCommand.hordeZombiesCanBreakBlocks ? "enabled, tier: " + HordeMobsCommand.hordeZombiesBlockBreakingTier : "disabled") + "\nDefault Horde: " + HordeSpawner.hordeIdFromHordesConfig + (HordeSpawner.hordeIdFromHordesConfig == 0 ? " (a horde will be chosen randomly)" : "") + "\n";
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity;
            serverPlayer.sendSystemMessage((Component)Component.literal((String)message));
        }
        if (HordeConfig.getReadingConfigFailed() && (entity = source.getEntity()) instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)entity;
            serverPlayer.sendSystemMessage((Component)Component.literal((String)"Reading horde config failed!\nPlease check: https://github.com/MC-Mods-Pete/UndeadNights/wiki").withStyle(ChatFormatting.YELLOW));
        }
        message = message + " (spawnedHordeMobs: " + UndeadNights.serverState.spawnedHordeMobs.size() + ", hordeMobsToRemove: " + UndeadNights.serverState.hordeMobsToRemove.size() + ")";
        if (MainConfig.getPrintDebugMessages()) {
            UndeadNights.LOGGER.info(message);
        }
        return 0;
    }
}

