/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.petemc.undeadnights.UndeadNights;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.difficulty.DifficultyLevel;
import net.petemc.undeadnights.config.difficulty.DifficultySettingDynamicScaling;

public class DifficultyLevelCommand {
    public DifficultyLevelCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"undeadnights").requires(source -> source.hasPermission(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"difficulty").then(Commands.literal((String)"query").executes(ctx -> this.queryDifficulty((CommandSourceStack)ctx.getSource())))).then(Commands.literal((String)"set").then(Commands.argument((String)"levelIndex", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> this.setDifficulty((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"levelIndex")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"auto_progression").then(Commands.literal((String)"enable").executes(ctx -> this.setAutoProgression((CommandSourceStack)ctx.getSource(), true)))).then(Commands.literal((String)"disable").executes(ctx -> this.setAutoProgression((CommandSourceStack)ctx.getSource(), false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dynamic_scaling").then(Commands.literal((String)"enable").executes(ctx -> this.setDynamicScaling((CommandSourceStack)ctx.getSource(), true)))).then(Commands.literal((String)"disable").executes(ctx -> this.setDynamicScaling((CommandSourceStack)ctx.getSource(), false)))).then(Commands.literal((String)"reset").executes(ctx -> this.resetDynamicScalingValues((CommandSourceStack)ctx.getSource()))))));
    }

    private int queryDifficulty(CommandSourceStack source) throws CommandSyntaxException {
        DifficultyLevel currentDifficultyLevel = UndeadNights.difficultyConfig.getCurrentDifficultyLevel();
        Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)("Current difficulty level: " + currentDifficultyLevel.getDifficultyName() + " (max: " + UndeadNights.difficultyConfig.getDifficultyLevels().size() + ")\nAutomatic difficulty progression: " + (UndeadNights.automaticDifficultyProgressionActive ? "enabled" : "disabled") + "\nDynamic scaling: " + (UndeadNights.difficultyConfig.getDynamicScaling().isDynamicScalingEnabled() != false ? "enabled" : "disabled") + "\nDynamic scaling day counter: " + UndeadNights.serverState.getCurrentDayScaleCounter() + " / " + String.format("%.0f", UndeadNights.difficultyConfig.getDynamicScaling().getDaysBetweenScaleIncreases()) + "\nCurrent health scaling: +" + String.format("%.1f", UndeadNights.serverState.getCurrentHealthScale() * 100.0) + "%\nCurrent speed scaling: +" + String.format("%.1f", UndeadNights.serverState.getCurrentSpeedScale() * 100.0) + "%\nCurrent damage scaling: +" + String.format("%.1f", UndeadNights.serverState.getCurrentDamageScale() * 100.0) + "%\nCurrent armor scaling: +" + String.format("%.1f", UndeadNights.serverState.getCurrentArmorScale() * 100.0) + "%\n")));
        return 1;
    }

    private int setDifficulty(CommandSourceStack source, int levelIndex) throws CommandSyntaxException {
        List<DifficultyLevel> difficultyLevels = UndeadNights.difficultyConfig.getDifficultyLevels();
        if (levelIndex <= 0 || levelIndex > difficultyLevels.size()) {
            Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)"Invalid difficulty level index!"));
            return 0;
        }
        UndeadNights.difficultyConfig.setCurrentDifficultyLevel(difficultyLevels.get(--levelIndex));
        UndeadNights.serverState.setCurrentDifficultyLevelIndex(levelIndex);
        UndeadNights.serverState.setPossibleHordesIndex(-1);
        HordeMobsCommand.hordeZombiesCanBreakBlocks = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isBlockBreaking();
        HordeMobsCommand.hordeZombiesBlockBreakingTier = UndeadNights.difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getBlockBreakingTier();
        Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)("Difficulty level set to: " + difficultyLevels.get(levelIndex).getDifficultyName())));
        return 1;
    }

    private int setAutoProgression(CommandSourceStack source, boolean value) {
        UndeadNights.automaticDifficultyProgressionActive = value;
        Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)("Automatic difficulty progression has been " + (value ? "enabled" : "disabled") + ".")));
        return 1;
    }

    private int setDynamicScaling(CommandSourceStack source, boolean value) {
        DifficultySettingDynamicScaling dynamicScaling = UndeadNights.difficultyConfig.getDynamicScaling();
        dynamicScaling.setDynamicScalingEnabled(value);
        Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)("Dynamic difficulty scaling has been " + (value ? "enabled" : "disabled") + ".")));
        return 1;
    }

    private int resetDynamicScalingValues(CommandSourceStack source) {
        UndeadNights.serverState.setCurrentHealthScale(0.0);
        UndeadNights.serverState.setCurrentSpeedScale(0.0);
        UndeadNights.serverState.setCurrentDamageScale(0.0);
        UndeadNights.serverState.setCurrentArmorScale(0.0);
        UndeadNights.serverState.setCurrentDayScaleCounter(0);
        Objects.requireNonNull(source.getEntity()).sendSystemMessage((Component)Component.literal((String)"Dynamic difficulty scaling values and day counter have been reset."));
        return 1;
    }
}

