/*
 * Decompiled with CFR 0.152.
 */
package net.petemc.undeadnights;

import com.mojang.logging.LogUtils;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.petemc.undeadnights.client.render.DemolitionZombieRenderer;
import net.petemc.undeadnights.client.render.EliteZombieRenderer;
import net.petemc.undeadnights.client.render.HordeZombieRenderer;
import net.petemc.undeadnights.command.HordeMobsCommand;
import net.petemc.undeadnights.config.HordeConfig;
import net.petemc.undeadnights.config.MainConfig;
import net.petemc.undeadnights.config.difficulty.DifficultyConfig;
import net.petemc.undeadnights.config.difficulty.DifficultyConfigLoader;
import net.petemc.undeadnights.effect.ModEffects;
import net.petemc.undeadnights.entity.ModEntities;
import net.petemc.undeadnights.item.ModCreativeModeTabs;
import net.petemc.undeadnights.item.ModItems;
import net.petemc.undeadnights.potion.ModPotions;
import net.petemc.undeadnights.sound.UndeadNightsSounds;
import net.petemc.undeadnights.util.StateSaverAndLoader;
import net.petemc.undeadnights.world.spawner.HordeSpawner;
import org.slf4j.Logger;

@Mod(value="undeadnights")
public class UndeadNights {
    public static final String MOD_ID = "undeadnights";
    public static final String MOD_NAME = "UndeadNights";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static StateSaverAndLoader serverState = null;
    public static DifficultyConfig difficultyConfig;
    public static int globalSpawnCounter;
    public static boolean automaticDifficultyProgressionActive;

    public UndeadNights(IEventBus modEventBus, ModContainer modContainer) {
        UndeadNightsSounds.register(modEventBus);
        ModEntities.register(modEventBus);
        ModItems.register(modEventBus);
        ModEffects.register(modEventBus);
        ModPotions.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MainConfig.SPEC_SERVER);
        HordeConfig.loadConfig();
        DifficultyConfigLoader.loadConfig();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing the {} Mod (common setup)", (Object)MOD_NAME);
        event.enqueueWork(() -> {});
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.SPAWN_EGGS) {
            event.accept((ItemLike)ModItems.HORDE_ZOMBIE_SPAWN_EGG.get());
            event.accept((ItemLike)ModItems.ELITE_ZOMBIE_SPAWN_EGG.get());
            event.accept((ItemLike)ModItems.DEMOLITION_ZOMBIE_SPAWN_EGG.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Initializing the {} Mod (server starting)", (Object)MOD_NAME);
        serverState = StateSaverAndLoader.getServerState(event.getServer());
        HordeSpawner.bossHordeTime = difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getAllDayLongHordeNights() != false ? 10300 : 21800;
        if (serverState.getCurrentDifficultyLevelIndex() >= difficultyConfig.getDifficultyLevels().size()) {
            LOGGER.warn("Current difficulty level index in server state is out of bounds, setting to max index");
            serverState.setCurrentDifficultyLevelIndex(difficultyConfig.getDifficultyLevels().size() - 1);
        }
        difficultyConfig.setCurrentDifficultyLevel(difficultyConfig.getDifficultyLevels().get(serverState.getCurrentDifficultyLevelIndex()));
        automaticDifficultyProgressionActive = MainConfig.getEnableAutomaticDifficultyProgression();
        if (serverState.getLastMaxDayScaleCounter() != difficultyConfig.getDynamicScaling().getDaysBetweenScaleIncreases().intValue()) {
            LOGGER.info("Day scale counter max value changed in config, resetting current day scale counter to 0");
            serverState.setCurrentDayScaleCounter(0);
            serverState.setLastMaxDayScaleCounter(difficultyConfig.getDynamicScaling().getDaysBetweenScaleIncreases().intValue());
        }
        if (serverState.getLastMaxDaysCounter() != difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights().intValue()) {
            serverState.setDaysCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
            serverState.setLastMaxDaysCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getDaysBetweenHordeNights());
        }
        if (serverState.getLastMaxGracePeriod() != MainConfig.getGracePeriodBeforeFirstHordeNight()) {
            serverState.setGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
            serverState.setLastMaxGracePeriod(MainConfig.getGracePeriodBeforeFirstHordeNight());
        }
        if (serverState.getLastMaxHordesCounter() != difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight().intValue()) {
            if (difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() != 0) {
                serverState.setHordesCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight() + 1);
            } else {
                serverState.setHordesCounter(0);
            }
            serverState.setLastMaxHordesCounter(difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeNights().getMaxHordesPerHordeNight());
        }
        if (!MainConfig.getNoNaturalSpawningBeforeFirstHordeNight()) {
            serverState.setIsNaturalSpawningOk(true);
        }
        if (MainConfig.getPrintDebugMessages()) {
            LOGGER.info("INIT DaysCounter: {} LastMaxDaysCounter: {}", (Object)serverState.getDaysCounter(), (Object)serverState.getLastMaxDaysCounter());
            LOGGER.info("INIT HordeNight: {} SpawnZombies: {} RespawnZombies: {}", new Object[]{serverState.getHordeNight(), serverState.getSpawnZombies(), serverState.getRespawnZombies()});
            LOGGER.info("INIT Difficulty level: {}", (Object)difficultyConfig.getCurrentDifficultyLevel().getDifficultyName());
        }
        HordeSpawner.hordeIdFromHordesConfig = HordeConfig.getDefaultHorde();
        HordeMobsCommand.hordeZombiesCanBreakBlocks = difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().isBlockBreaking();
        HordeMobsCommand.hordeZombiesBlockBreakingTier = difficultyConfig.getCurrentDifficultyLevel().getDifficultySettingsHordeMobs().getBlockBreakingTier();
    }

    static {
        globalSpawnCounter = 0;
        automaticDifficultyProgressionActive = false;
    }

    @EventBusSubscriber(modid="undeadnights", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register(ModEntities.HORDE_ZOMBIE.get(), HordeZombieRenderer::new);
            EntityRenderers.register(ModEntities.DEMOLITION_ZOMBIE.get(), DemolitionZombieRenderer::new);
            EntityRenderers.register(ModEntities.ELITE_ZOMBIE.get(), EliteZombieRenderer::new);
        }
    }
}

