/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.worldgen.processors;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModStructureProcessors;

public class SlothPaintingRandomizerProcessor
extends StructureProcessor {
    public static final List<List<Block>> PAINTINGS = new ArrayList<List<Block>>(){
        {
            this.add(Collections.singletonList((Block)ModBlocks.PERMAFROST_BURREL_PAINTING.get()));
            this.add(Collections.singletonList((Block)ModBlocks.PERMAFROST_SPEARTOOTH_PAINTING.get()));
            this.add(Collections.singletonList((Block)ModBlocks.PERMAFROST_SNOWDO_PAINTING.get()));
            this.add(Collections.singletonList((Block)ModBlocks.PERMAFROST_GLACEROS_PAINTING.get()));
            this.add(Collections.singletonList((Block)ModBlocks.PERMAFROST_PSYCHO_BEAR_PAINTING.get()));
            this.add(List.of((Block)ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_BOTTOM_LEFT.get(), (Block)ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_BOTTOM_RIGHT.get(), (Block)ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_TOP_LEFT.get(), (Block)ModBlocks.PERMAFROST_FROSTOMPER_PAINTING_TOP_RIGHT.get()));
        }
    };
    public static MapCodec<SlothPaintingRandomizerProcessor> CODEC = new MapCodec<SlothPaintingRandomizerProcessor>(){

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.empty();
        }

        public <T> DataResult<SlothPaintingRandomizerProcessor> decode(DynamicOps<T> ops, MapLike<T> input) {
            return DataResult.success((Object)((Object)new SlothPaintingRandomizerProcessor()));
        }

        public <T> RecordBuilder<T> encode(SlothPaintingRandomizerProcessor input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return prefix;
        }
    };

    @NotNull
    public List<StructureTemplate.StructureBlockInfo> finalizeProcessing(@NotNull ServerLevelAccessor serverLevel, @NotNull BlockPos offset, @NotNull BlockPos pos, @NotNull List<StructureTemplate.StructureBlockInfo> originalBlockInfos, @NotNull List<StructureTemplate.StructureBlockInfo> processedBlockInfos, @NotNull StructurePlaceSettings settings) {
        ArrayList<StructureTemplate.StructureBlockInfo> newInfo = new ArrayList<StructureTemplate.StructureBlockInfo>(List.copyOf(processedBlockInfos));
        ArrayList selectedPaintings = new ArrayList();
        Random random = new Random();
        PAINTINGS.stream().filter(blocks -> random.nextBoolean()).forEach(selectedPaintings::addAll);
        processedBlockInfos.stream().filter(info -> BuiltInRegistries.BLOCK.getKey((Object)info.state().getBlock()).getPath().contains("painting")).forEach(info -> {
            if (!selectedPaintings.contains(info.state().getBlock())) {
                newInfo.removeIf(info2 -> info2 == info);
                newInfo.add(new StructureTemplate.StructureBlockInfo(info.pos(), ((Block)ModBlocks.PERMAFROST.BLOCK.get()).defaultBlockState(), null));
            }
        });
        return newInfo;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)ModStructureProcessors.SLOTH_PAINTING_RANDOMIZER.get();
    }
}

