/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.worldgen.feature;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModFoliageTypes;

public class CedarFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<CedarFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(p_68735_ -> CedarFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)p_68735_).apply((Applicative)p_68735_, CedarFoliagePlacer::new));

    public CedarFoliagePlacer(IntProvider radius, IntProvider offset) {
        super(radius, offset);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)ModFoliageTypes.CEDAR_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader level, FoliagePlacer.FoliageSetter blockSetter, RandomSource random, TreeConfiguration config, int maxFreeTreeHeight, FoliagePlacer.FoliageAttachment attachment, int foliageHeight, int foliageRadius, int offset) {
        BlockPos blockPos = attachment.pos();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = blockPos.mutable();
        Vec3 vec3 = blockPos.getCenter();
        foliageHeight = 10;
        for (BlockPos blockPos2 : BlockPos.betweenClosed((BlockPos)blockPos.offset(-3, -8, -3), (BlockPos)blockPos.offset(3, -8, 3))) {
            if (!(blockPos2.distToCenterSqr(vec3.x(), (double)blockPos2.getY() + 0.5, vec3.z()) <= 9.0)) continue;
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)blockPos2);
        }
        for (int i = 0; i < 8; ++i) {
            blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, random.nextInt(4) - random.nextInt(4), -4, random.nextInt(4) - random.nextInt(4));
            BlockPos blockPos2 = blockpos$mutableblockpos.immutable();
            if (!level.isStateAtPosition(blockPos2.east(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get()) && !level.isStateAtPosition(blockPos2.west(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get()) && !level.isStateAtPosition(blockPos2.south(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get()) && !level.isStateAtPosition(blockPos2.north(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get())) continue;
            CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)blockpos$mutableblockpos);
        }
        for (int l = -7; l < foliageHeight - 6; ++l) {
            for (BlockPos blockPos2 : BlockPos.betweenClosed((BlockPos)blockPos.offset(-2, l, -2), (BlockPos)blockPos.offset(2, l, 2))) {
                if (!(blockPos2.distToCenterSqr(vec3.x(), (double)blockPos2.getY() + 0.5, vec3.z()) <= 1.0)) continue;
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)blockPos2);
            }
            for (int i = 0; i < 16 - l * 2; ++i) {
                blockpos$mutableblockpos.setWithOffset((Vec3i)blockPos, random.nextInt(3) - random.nextInt(3), l, random.nextInt(3) - random.nextInt(3));
                BlockPos blockPos2 = blockpos$mutableblockpos.immutable();
                if (!level.isStateAtPosition(blockPos2.east(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get()) && !level.isStateAtPosition(blockPos2.west(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get()) && !level.isStateAtPosition(blockPos2.south(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get()) && !level.isStateAtPosition(blockPos2.north(), blockState -> blockState.getBlock() == ModBlocks.CEDAR.LEAVES.get())) continue;
                CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)blockpos$mutableblockpos);
            }
        }
        CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)blockPos.above(offset + foliageHeight - 6));
        CedarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)level, (FoliagePlacer.FoliageSetter)blockSetter, (RandomSource)random, (TreeConfiguration)config, (BlockPos)blockPos.above(offset + foliageHeight - 5));
    }

    public int foliageHeight(RandomSource random, int height, TreeConfiguration config) {
        return height + random.nextIntBetweenInclusive(7, 10);
    }

    protected boolean shouldSkipLocation(RandomSource random, int localX, int localY, int localZ, int range, boolean large) {
        return false;
    }
}

