/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.util;

import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShapeUtils {
    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape second) {
        return Shapes.joinUnoptimized((VoxelShape)first, (VoxelShape)second, (BooleanOp)BooleanOp.OR);
    }

    public static VoxelShape orUnoptimized(VoxelShape first, VoxelShape ... others) {
        for (VoxelShape shape : others) {
            first = ShapeUtils.orUnoptimized(first, shape);
        }
        return first;
    }

    public static VoxelShape rotateShape(Direction from, Direction to, VoxelShape shape) {
        return ShapeUtils.rotateShapeUnoptimized(from, to, shape).optimize();
    }

    public static boolean isY(Direction direction) {
        return direction.getAxis() == Direction.Axis.Y;
    }

    public static VoxelShape rotateShapeUnoptimized(Direction from, Direction to, VoxelShape shape) {
        if (ShapeUtils.isY(from) || ShapeUtils.isY(to)) {
            throw new IllegalArgumentException("Invalid Direction!");
        }
        if (from == to) {
            return shape;
        }
        List sourceBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        int times = (to.get2DDataValue() - from.get2DDataValue() + 4) % 4;
        for (AABB box : sourceBoxes) {
            for (int i = 0; i < times; ++i) {
                box = new AABB(1.0 - box.maxZ, box.minY, box.minX, 1.0 - box.minZ, box.maxY, box.maxX);
            }
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateShape(VoxelShape shape, Direction.Axis axis, Direction facing) {
        VoxelShape rotatedShape = shape;
        switch (axis) {
            case X: {
                rotatedShape = ShapeUtils.rotateYtoX(ShapeUtils.rotateXtoZ(shape));
                break;
            }
            case Z: {
                rotatedShape = ShapeUtils.rotateYtoX(ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(shape))));
                break;
            }
        }
        rotatedShape = ShapeUtils.rotateBasedOnFacing(rotatedShape, axis, facing);
        return rotatedShape;
    }

    public static VoxelShape rotateBasedOnFacing(VoxelShape shape, Direction.Axis axis, Direction facing) {
        if (axis == Direction.Axis.Y) {
            return shape;
        }
        switch (facing) {
            case NORTH: {
                return ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(shape));
            }
            case EAST: {
                return ShapeUtils.rotateXtoZ(shape);
            }
            case WEST: {
                return ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(ShapeUtils.rotateXtoZ(shape)));
            }
        }
        return shape;
    }

    public static VoxelShape rotateXtoZ(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.maxZ, box.minY, box.minX, 1.0 - box.minZ, box.maxY, box.maxX);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateYtoX(VoxelShape shape) {
        List sourceBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : sourceBoxes) {
            AABB rotatedBox = new AABB(box.minX, 1.0 - box.maxZ, box.minY, box.maxX, 1.0 - box.minZ, box.maxY);
            rotatedShape = Shapes.or((VoxelShape)rotatedShape, (VoxelShape)Shapes.create((AABB)rotatedBox));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateYtoZ(VoxelShape shape) {
        List sourceBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : sourceBoxes) {
            AABB rotatedBox = new AABB(1.0 - box.maxX, box.minY, box.minZ, 1.0 - box.minX, box.maxY, box.maxZ);
            rotatedShape = Shapes.or((VoxelShape)rotatedShape, (VoxelShape)Shapes.create((AABB)rotatedBox));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoZ(VoxelShape shape, int times) {
        VoxelShape rotatedShape = shape;
        for (int i = 0; i < times; ++i) {
            rotatedShape = ShapeUtils.rotateXtoZ(rotatedShape);
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoZFlippedY(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.maxZ, box.maxY, box.minX, 1.0 - box.minZ, box.minY, box.maxX);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape flipY(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(box.minX, box.maxY, box.minZ, box.maxX, box.minY, box.maxZ);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape floorToCeiling(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(box.maxZ, 1.0 - box.maxY, box.minX, box.minZ, 1.0 - box.minY, box.maxX);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoEast(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(box.maxY, box.maxX, 1.0 - box.maxZ, box.minY, box.minX, 1.0 - box.minZ);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoWest(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.maxY, box.minX, box.minZ, 1.0 - box.minY, box.maxX, box.maxZ);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoNorth(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(1.0 - box.maxZ, box.minX, 1.0 - box.minY, 1.0 - box.minZ, box.maxX, 1.0 - box.maxY);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }

    public static VoxelShape rotateXtoSouth(VoxelShape shape) {
        List soureBoxes = shape.toAabbs();
        VoxelShape rotatedShape = Shapes.empty();
        for (AABB box : soureBoxes) {
            box = new AABB(box.maxZ, box.maxX, box.maxY, box.minZ, box.minX, box.minY);
            rotatedShape = ShapeUtils.orUnoptimized(rotatedShape, Shapes.create((AABB)box));
        }
        return rotatedShape;
    }
}

