/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.util;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HitboxHelper {
    public static double getDistSqrBetweenHitboxes(AABB first, AABB second) {
        double distSqr = 0.0;
        distSqr += Mth.square((double)HitboxHelper.getDistBetweenCorners(first.minX, second.minX, first.maxX, second.maxX));
        distSqr += Mth.square((double)HitboxHelper.getDistBetweenCorners(first.minY, second.minY, first.maxY, second.maxY));
        return distSqr += Mth.square((double)HitboxHelper.getDistBetweenCorners(first.minZ, second.minZ, first.maxZ, second.maxZ));
    }

    private static double getDistBetweenCorners(double min1, double min2, double max1, double max2) {
        if (max2 < min1) {
            return max2 - min1;
        }
        if (min2 > max1) {
            return min2 - max1;
        }
        return 0.0;
    }

    public static double getDistSqrBetweenHitboxes(Entity first, Entity second) {
        return HitboxHelper.getDistSqrBetweenHitboxes(first.getBoundingBox(), second.getBoundingBox());
    }

    public static double getDistSqrFromHitbox(Entity entity, Vec3 target) {
        return HitboxHelper.getDistSqrFromHitbox(entity.getBoundingBox(), target);
    }

    public static double getDistSqrFromHitbox(AABB box, Vec3 target) {
        return box.distanceToSqr(target);
    }

    public static boolean isCloseEnoughForTargeting(LivingEntity attacker, LivingEntity target, boolean testInvisible, double range) {
        double visibilityPercent = testInvisible ? target.getVisibilityPercent((Entity)attacker) : 1.0;
        double maxDistance = Math.max(range * visibilityPercent, 2.0);
        double distanceToSqr = HitboxHelper.getDistSqrBetweenHitboxes((Entity)attacker, (Entity)target);
        return !(distanceToSqr > Mth.square((double)maxDistance));
    }

    public static float pixelsToBlocks(float pixels) {
        return pixels / 16.0f;
    }

    public static AABB createHitboxRelativeToFront(LivingEntity mob, double xSize, double ySize, double zSize) {
        Vec3 baseOffset = Vec3.ZERO.add(0.0, 0.0, (double)mob.getBbWidth() * 0.5).yRot(-mob.getYHeadRot() * ((float)Math.PI / 180));
        Vec3 radiusOffset = Vec3.ZERO.add(0.0, ySize * 0.5, zSize * 0.5).yRot(-mob.getYHeadRot() * ((float)Math.PI / 180));
        Vec3 centerPos = mob.position().add(baseOffset).add(radiusOffset);
        return AABB.ofSize((Vec3)centerPos, (double)xSize, (double)ySize, (double)zSize);
    }

    public static double calculateMinimumAttackHitboxWidth(double hitboxWidth) {
        double halfWidth = hitboxWidth * 0.5;
        return 2.0 * (Math.hypot(halfWidth, halfWidth) - halfWidth);
    }

    public static double getHitboxAdjustedDistance(LivingEntity mob, double distance) {
        return HitboxHelper.getHitboxAdjustedDistance(mob.getBbWidth(), distance);
    }

    public static double getHitboxAdjustedDistance(float width, double distance) {
        double halfWidth = (double)width * 0.5;
        return Math.hypot(halfWidth, halfWidth) + distance;
    }
}

