/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.util;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import team.recrafted.blastfromthepast.entity.HollowEntity;
import team.recrafted.blastfromthepast.entity.misc.AnimatedAttacker;
import team.recrafted.blastfromthepast.init.ModEnchantments;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModTags;

public class EntityHelper {
    private static final GameProfile BLAST_FROM_THE_PAST = new GameProfile(UUID.fromString("cf41e056-477d-4afa-bcdb-39d84cb95f14"), "[Blast From The Past]");

    public static void spawnSmashAttackParticles(LevelAccessor level, AABB attackBounds, int power) {
        double zSpeed;
        double ySpeed;
        double xSpeed;
        double z;
        double y;
        double x;
        Vec3 boundsBottomCenter = attackBounds.getBottomCenter();
        double radius = EntityHelper.getXZSize(attackBounds);
        double halfRadius = radius * 0.5;
        BlockPos pos = BlockPos.containing((Position)boundsBottomCenter.subtract(0.0, (double)1.0E-5f, 0.0));
        Vec3 particleCenter = boundsBottomCenter.add(0.0, 0.5, 0.0);
        BlockParticleOption dustPillar = new BlockParticleOption(ParticleTypes.DUST_PILLAR, level.getBlockState(pos));
        int index = 0;
        while ((double)index < (double)power / radius) {
            x = particleCenter.x + level.getRandom().nextGaussian() / 2.0;
            y = particleCenter.y;
            z = particleCenter.z + level.getRandom().nextGaussian() / 2.0;
            xSpeed = level.getRandom().nextGaussian() * 0.2;
            ySpeed = level.getRandom().nextGaussian() * 0.2;
            zSpeed = level.getRandom().nextGaussian() * 0.2;
            level.addParticle((ParticleOptions)dustPillar, x, y, z, xSpeed, ySpeed, zSpeed);
            ++index;
        }
        index = 0;
        while ((double)index < (double)power / halfRadius) {
            x = particleCenter.x + attackBounds.getXsize() * Math.cos(index) + level.getRandom().nextGaussian() / 2.0;
            y = particleCenter.y;
            z = particleCenter.z + attackBounds.getZsize() * Math.sin(index) + level.getRandom().nextGaussian() / 2.0;
            xSpeed = level.getRandom().nextGaussian() * 0.05;
            ySpeed = level.getRandom().nextGaussian() * 0.05;
            zSpeed = level.getRandom().nextGaussian() * 0.05;
            level.addParticle((ParticleOptions)dustPillar, x, y, z, xSpeed, ySpeed, zSpeed);
            ++index;
        }
    }

    public static double getXZSize(AABB bounds) {
        double xSize = bounds.getXsize();
        double zSize = bounds.getZsize();
        return (xSize + zSize) / 2.0;
    }

    public static <T extends Mob, A extends AnimatedAttacker.AttackType<T, A>> List<LivingEntity> hitTargetsWithAOEAttack(T attacker, AABB attackBounds, float attackDamage, float attackKnockback, boolean spawnParticles) {
        ArrayList<LivingEntity> hitTargets = new ArrayList<LivingEntity>();
        if (!attacker.level().isClientSide) {
            List targets = attacker.level().getNearbyEntities(LivingEntity.class, TargetingConditions.DEFAULT, attacker, attackBounds);
            targets.forEach(target -> {
                boolean hurtTarget;
                if (target.invulnerableTime <= 0 && (hurtTarget = EntityHelper.doHurtTarget((LivingEntity)attacker, target, attackDamage, attackKnockback))) {
                    hitTargets.add((LivingEntity)target);
                }
            });
        } else if (spawnParticles) {
            EntityHelper.spawnSmashAttackParticles((LevelAccessor)attacker.level(), attackBounds, 750);
        }
        return hitTargets;
    }

    public static boolean doHurtTarget(LivingEntity attacker, LivingEntity target, float attackDamage, float attackKnockback) {
        boolean hurt;
        DamageSource damagesource = attacker.damageSources().mobAttack(attacker);
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            attackDamage = EnchantmentHelper.modifyDamage((ServerLevel)serverlevel, (ItemStack)attacker.getWeaponItem(), (Entity)target, (DamageSource)damagesource, (float)attackDamage);
        }
        if (hurt = target.hurt(damagesource, attackDamage)) {
            ServerLevel serverlevel;
            Level level2 = attacker.level();
            if (level2 instanceof ServerLevel) {
                serverlevel = (ServerLevel)level2;
                attackKnockback = EnchantmentHelper.modifyKnockback((ServerLevel)serverlevel, (ItemStack)attacker.getWeaponItem(), (Entity)attacker, (DamageSource)damagesource, (float)attackKnockback);
            }
            if (attackKnockback > 0.0f) {
                target.knockback((double)(attackKnockback * 0.5f), (double)Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)))));
                attacker.setDeltaMovement(attacker.getDeltaMovement().multiply(0.6, 1.0, 0.6));
            }
            if ((level2 = attacker.level()) instanceof ServerLevel) {
                serverlevel = (ServerLevel)level2;
                EnchantmentHelper.doPostAttackEffects((ServerLevel)serverlevel, (Entity)target, (DamageSource)damagesource);
            }
            attacker.setLastHurtMob((Entity)target);
        }
        return hurt;
    }

    public static void throwTarget(LivingEntity attacker, LivingEntity target, double attackKnockback) {
        double knockbackResistance = target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        double effectiveKnockback = attackKnockback - knockbackResistance;
        if (effectiveKnockback > 0.0) {
            double knockbackScale = effectiveKnockback * 0.5;
            Vec3 knockbackVec = attacker.getViewVector(1.0f).normalize().scale(knockbackScale);
            target.push(knockbackVec.x, knockbackScale, knockbackVec.z);
            target.hurtMarked = true;
        }
    }

    public static void strongKnockback(LivingEntity attacker, LivingEntity target, double attackKnockback) {
        double knockbackResistance = target.getAttributeValue(Attributes.KNOCKBACK_RESISTANCE);
        double effectiveKnockback = attackKnockback - knockbackResistance;
        if (effectiveKnockback > 0.0) {
            Vec3 knockbackVec = attacker.getViewVector(1.0f).normalize().scale(effectiveKnockback);
            target.push(knockbackVec.x, target.onGround() ? Math.min(0.4, effectiveKnockback) : 0.0, knockbackVec.z);
            target.hurtMarked = true;
        }
    }

    public static TagKey<DamageType> getPanicInducingDamageTypes(PathfinderMob mob) {
        return mob.isBaby() ? DamageTypeTags.PANIC_CAUSES : DamageTypeTags.PANIC_ENVIRONMENTAL_CAUSES;
    }

    public static FakePlayer getFakePlayer(ServerLevel serverLevel) {
        return FakePlayerFactory.get((ServerLevel)serverLevel, (GameProfile)BLAST_FROM_THE_PAST);
    }

    public static double getFollowRange(Mob mob) {
        return mob.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    public static boolean hasBlocksAbove(PathfinderMob mob, BlockPos targetPos) {
        return !mob.level().canSeeSky(targetPos) && (double)mob.level().getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, targetPos).getY() > mob.getY();
    }

    public static boolean isLookingAt(LivingEntity looker, LivingEntity target, double leniencyFactor, boolean requireLOS, boolean checkBody) {
        double leniency;
        Vec3 viewVector = looker.getViewVector(1.0f).normalize();
        Vec3 vectorToTarget = looker.getEyePosition().vectorTo(target.getEyePosition());
        double distanceToTarget = vectorToTarget.length();
        return !(!EntityHelper.sameDirection(viewVector, vectorToTarget = vectorToTarget.normalize(), leniency = leniencyFactor / distanceToTarget) || requireLOS && !looker.hasLineOfSight((Entity)target) || checkBody && !EntityHelper.sameDirection(EntityHelper.getBodyViewVector(looker, 1.0f).normalize(), vectorToTarget, leniency));
    }

    private static boolean sameDirection(Vec3 a, Vec3 b, double leniency) {
        return a.dot(b) >= 1.0 - leniency;
    }

    public static Vec3 getBodyViewVector(LivingEntity looker, float partialTicks) {
        return looker.calculateViewVector(looker.getViewXRot(partialTicks), partialTicks == 1.0f ? looker.yBodyRot : Mth.lerp((float)partialTicks, (float)looker.yBodyRotO, (float)looker.yBodyRot));
    }

    public static boolean isLookingAwayFrom(LivingEntity looker, Vec3 target, double leniencyFactor, boolean checkBody, boolean checkY) {
        double leniency;
        Vec3 viewVector = looker.getViewVector(1.0f).multiply(1.0, checkY ? 1.0 : 0.0, 1.0).normalize();
        Vec3 vectorAwayFromTarget = target.vectorTo(looker.getEyePosition()).multiply(1.0, checkY ? 1.0 : 0.0, 1.0);
        double distanceAwayFromTarget = vectorAwayFromTarget.length();
        return EntityHelper.sameDirection(viewVector, vectorAwayFromTarget = vectorAwayFromTarget.normalize(), leniency = leniencyFactor / distanceAwayFromTarget) && (!checkBody || EntityHelper.sameDirection(EntityHelper.getBodyViewVector(looker, 1.0f).multiply(1.0, checkY ? 1.0 : 0.0, 1.0).normalize(), vectorAwayFromTarget, leniency));
    }

    public static boolean canWalkOnTarBlocks(LivingEntity entity) {
        ItemStack boots = entity.getItemBySlot(EquipmentSlot.FEET);
        return boots.is(ModTags.Items.ALLOWS_WALKING_ON_TAR) || boots.getEnchantmentLevel(ModEnchantments.TAR_MARCHER) != 0;
    }

    public static boolean noBlockCollisions(LivingEntity entity) {
        return !entity.level().getBlockCollisions((Entity)entity, entity.getBoundingBox()).iterator().hasNext();
    }

    @Nullable
    public static BlockPos findSafeSpot(LivingEntity entity) {
        BlockPos.MutableBlockPos newPos;
        int newY;
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        HollowEntity dummyHollow = (HollowEntity)((EntityType)ModEntities.HOLLOW.get()).create((Level)serverLevel);
        assert (dummyHollow != null);
        BlockPos validBlockPos = serverLevel.getWorldBorder().clampToBounds(entity.position());
        Vec3 validPos = new Vec3((double)validBlockPos.getX(), Mth.clamp((double)entity.getY(), (double)serverLevel.getMinBuildHeight(), (double)serverLevel.getMaxBuildHeight()), (double)validBlockPos.getZ());
        dummyHollow.setPos(validPos);
        if (validPos.y > (double)serverLevel.getMinBuildHeight()) {
            if (EntityHelper.noBlockCollisions(dummyHollow)) {
                return entity.blockPosition();
            }
            double originalY = entity.getY();
            for (int offsetY = 0; offsetY < 12; offsetY += 2) {
                dummyHollow.setPos(entity.getX(), originalY + (double)offsetY, entity.getZ());
                if (!EntityHelper.noBlockCollisions(dummyHollow)) continue;
                return entity.blockPosition().above(offsetY);
            }
        }
        BlockPos teleportPos = null;
        BlockPos potentialPos = null;
        Iterator iterator = BlockPos.spiralAround((BlockPos)BlockPos.containing((Position)dummyHollow.position()), (int)32, (Direction)Direction.SOUTH, (Direction)Direction.WEST).iterator();
        while (iterator.hasNext() && (newY = serverLevel.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (newPos = (BlockPos.MutableBlockPos)iterator.next()).getX(), newPos.getZ())) < serverLevel.getLogicalHeight()) {
            dummyHollow.setPos(newPos.getX(), (double)newY + 0.01, newPos.getZ());
            if (EntityHelper.noBlockCollisions(dummyHollow)) {
                if (newY == serverLevel.getMinBuildHeight()) {
                    if (potentialPos != null) continue;
                    potentialPos = BlockPos.containing((Position)dummyHollow.position());
                    continue;
                }
                teleportPos = BlockPos.containing((Position)dummyHollow.position());
                break;
            }
            if (potentialPos != null) continue;
            dummyHollow.setPos(newPos.getX(), newY + 1, newPos.getZ());
            if (!EntityHelper.noBlockCollisions(dummyHollow)) continue;
            potentialPos = BlockPos.containing((Position)dummyHollow.position());
        }
        if (teleportPos == null) {
            teleportPos = potentialPos;
        }
        return teleportPos;
    }

    public static boolean shouldCreateHollow(ServerPlayer player) {
        return !player.serverLevel().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && EntityHelper.getIdolOfRetrievalInHand(player) != null && !player.isSpectator();
    }

    @Nullable
    public static ItemStack getIdolOfRetrievalInHand(ServerPlayer player) {
        if (player.getMainHandItem().is(ModItems.IDOL_OF_RETRIEVAL)) {
            return player.getMainHandItem();
        }
        if (player.getOffhandItem().is(ModItems.IDOL_OF_RETRIEVAL)) {
            return player.getOffhandItem();
        }
        return null;
    }

    public static boolean isWearingFrostbiteSet(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.HEAD).is(ModItems.FROST_BITE_HELMET) && entity.getItemBySlot(EquipmentSlot.CHEST).is(ModItems.FROST_BITE_CHESTPLATE) && entity.getItemBySlot(EquipmentSlot.LEGS).is(ModItems.FROST_BITE_LEGGINGS) && entity.getItemBySlot(EquipmentSlot.FEET).is(ModItems.FROST_BITE_BOOTS);
    }

    public static boolean isWearingFrostbiteBoots(LivingEntity entity) {
        return entity.getItemBySlot(EquipmentSlot.FEET).is(ModItems.FROST_BITE_BOOTS);
    }
}

