/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.network;

import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.recrafted.blastfromthepast.entity.FrostomperEntity;
import team.recrafted.blastfromthepast.entity.SnowdoEntity;
import team.recrafted.blastfromthepast.network.FrostomperCollidePayload;
import team.recrafted.blastfromthepast.network.RiddenEntityPayload;

public class ServerPayloadHandler {
    public static void handleRiddenEntityPayload(RiddenEntityPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity riding = context.player().level().getEntity(payload.entityId());
            assert (riding != null);
            riding.stopRiding();
            if (riding instanceof SnowdoEntity) {
                SnowdoEntity snowdoEntity = (SnowdoEntity)riding;
                snowdoEntity.setRiddenPlayer(Optional.empty());
            }
            context.player().level().playSound(null, context.player().blockPosition(), SoundEvents.GENERIC_SMALL_FALL, SoundSource.PLAYERS, 1.0f, 1.0f);
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)"blastfromthepast Networking Failed"));
            return null;
        });
    }

    public static void handleFroststomperCollidePayload(FrostomperCollidePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Entity entity = context.player().level().getEntity(payload.entityId());
            if (entity instanceof FrostomperEntity) {
                FrostomperEntity frostomperEntity = (FrostomperEntity)entity;
                frostomperEntity.serverHorizontalCollide = payload.isColliding();
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.literal((String)"blastfromthepast Networking Failed"));
            return null;
        });
    }
}

