/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BearGloveItem
extends Item {
    public static final ItemAttributeModifiers FAST = BearGloveItem.createAttributes(5.0f, -2.0f);
    public static final ItemAttributeModifiers SLOW = BearGloveItem.createAttributes(5.0f, -3.0f);

    public BearGloveItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (isSelected && player.getOffhandItem().getItem() == this) {
                stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)FAST);
            } else {
                stack.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)SLOW);
            }
        }
    }

    public static ItemAttributeModifiers createAttributes(int attackDamage, float attackSpeed) {
        return BearGloveItem.createAttributes((float)attackDamage, attackSpeed);
    }

    public static ItemAttributeModifiers createAttributes(float p_331976_, float p_332104_) {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, (double)p_331976_, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)p_332104_, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return true;
    }

    public void postHurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
    }
}

