/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import team.recrafted.blastfromthepast.entity.BurrelEntity;
import team.recrafted.blastfromthepast.entity.FrostomperEntity;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;
import team.recrafted.blastfromthepast.entity.HollowEntity;
import team.recrafted.blastfromthepast.entity.PsychoBearEntity;
import team.recrafted.blastfromthepast.entity.SapEntity;
import team.recrafted.blastfromthepast.entity.SnowdoEntity;
import team.recrafted.blastfromthepast.entity.TarArrow;
import team.recrafted.blastfromthepast.entity.boats.BFTPBoat;
import team.recrafted.blastfromthepast.entity.boats.BFTPChestBoat;
import team.recrafted.blastfromthepast.entity.projectile.ThrownIceSpear;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;
import team.recrafted.blastfromthepast.util.HitboxHelper;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"blastfromthepast");
    public static final DeferredHolder<EntityType<?>, EntityType<GlacerosEntity>> GLACEROS = ModEntities.registerMob("glaceros", GlacerosEntity::new, 1.0f, 2.2f);
    public static final DeferredHolder<EntityType<?>, EntityType<SnowdoEntity>> SNOWDO = ModEntities.registerMob("snowdo", SnowdoEntity::new, 0.6f, 1.1f);
    public static final DeferredHolder<EntityType<?>, EntityType<FrostomperEntity>> FROSTOMPER = ModEntities.registerMobWithEyeHeight("frostomper", FrostomperEntity::new, 4.0f, HitboxHelper.pixelsToBlocks(70.0f), HitboxHelper.pixelsToBlocks(70.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<SpeartoothEntity>> SPEARTOOTH = ModEntities.registerMobWithEyeHeight("speartooth", SpeartoothEntity::new, 0.9f, 1.3f, 1.25f);
    public static final DeferredHolder<EntityType<?>, EntityType<BurrelEntity>> BURREL = ModEntities.registerMob("burrel", BurrelEntity::new, 1.0f, 1.0f);
    public static final DeferredHolder<EntityType<?>, EntityType<ThrownIceSpear>> ICE_SPEAR = ENTITIES.register("ice_spear", () -> EntityType.Builder.of(ThrownIceSpear::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).updateInterval(20).build("ice_spear"));
    public static final DeferredHolder<EntityType<?>, EntityType<SapEntity>> SAP = ENTITIES.register("sap", () -> EntityType.Builder.of(SapEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).eyeHeight(0.0f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build(ModEntities.getName("sap")));
    public static final DeferredHolder<EntityType<?>, EntityType<BFTPBoat>> BFTPBOAT = ENTITIES.register("boat", () -> EntityType.Builder.of(BFTPBoat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10).build(ModEntities.getName("boat")));
    public static final DeferredHolder<EntityType<?>, EntityType<BFTPChestBoat>> BFTPCHEST_BOAT = ENTITIES.register("chest_boat", () -> EntityType.Builder.of(BFTPChestBoat::new, (MobCategory)MobCategory.MISC).sized(1.375f, 0.5625f).clientTrackingRange(10).build(ModEntities.getName("chest_boat")));
    public static final DeferredHolder<EntityType<?>, EntityType<PsychoBearEntity>> PSYCHO_BEAR = ModEntities.registerMob("psycho_bear", PsychoBearEntity::new, HitboxHelper.pixelsToBlocks(53.0f), HitboxHelper.pixelsToBlocks(33.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<HollowEntity>> HOLLOW = ENTITIES.register("hollow", () -> EntityType.Builder.of(HollowEntity::new, (MobCategory)MobCategory.MISC).sized(1.3f, 2.3f).clientTrackingRange(10).build(ModEntities.getName("hollow")));
    public static final DeferredHolder<EntityType<?>, EntityType<TarArrow>> TAR_ARROW = ENTITIES.register("tar_arrow", () -> EntityType.Builder.of(TarArrow::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(4).build(ModEntities.getName("tar_arrow")));

    public static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> registerMob(String name, EntityType.EntityFactory<T> entity, float width, float height) {
        DeferredHolder entityType = ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).sized(width, height).build(name));
        return entityType;
    }

    public static <T extends Mob> DeferredHolder<EntityType<?>, EntityType<T>> registerMobWithEyeHeight(String name, EntityType.EntityFactory<T> entity, float width, float height, float eyeHeight) {
        return ENTITIES.register(name, () -> EntityType.Builder.of((EntityType.EntityFactory)entity, (MobCategory)MobCategory.CREATURE).sized(width, height).eyeHeight(eyeHeight).build(name));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GLACEROS.get(), GlacerosEntity.createAttributes().build());
        event.put((EntityType)SNOWDO.get(), SnowdoEntity.createAttributes().build());
        event.put((EntityType)SPEARTOOTH.get(), SpeartoothEntity.createAttributes().build());
        event.put((EntityType)BURREL.get(), BurrelEntity.createAttributes().build());
        event.put((EntityType)FROSTOMPER.get(), FrostomperEntity.createAttributes().build());
        event.put((EntityType)PSYCHO_BEAR.get(), PsychoBearEntity.createAttributes().build());
        event.put((EntityType)HOLLOW.get(), HollowEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.GRAVITY, 0.0).build());
    }

    private static String getName(String name) {
        return "blastfromthepast:" + name;
    }
}

