/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.CriterionValidator;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.storage.loot.LootContext;
import team.recrafted.blastfromthepast.BlastFromThePast;

public class ModCriteriaTriggers {
    public static final DanceTrigger DANCE_TRIGGER = new DanceTrigger();
    public static final PacifyBearTrigger PACIFY_BEAR_TRIGGER = new PacifyBearTrigger();

    public static void init() {
        Registry.register((Registry)BuiltInRegistries.TRIGGER_TYPES, (ResourceLocation)BlastFromThePast.location("dance_trigger"), (Object)((Object)DANCE_TRIGGER));
        Registry.register((Registry)BuiltInRegistries.TRIGGER_TYPES, (ResourceLocation)BlastFromThePast.location("pacify_bear_trigger"), (Object)((Object)PACIFY_BEAR_TRIGGER));
    }

    public static class DanceTrigger
    extends SimpleCriterionTrigger<TriggerInstance> {
        public Codec<TriggerInstance> codec() {
            return TriggerInstance.CODEC;
        }

        public void trigger(ServerPlayer player, Animal entity) {
            LootContext lootcontext = EntityPredicate.createContext((ServerPlayer)player, (Entity)entity);
            this.trigger(player, p_68838_ -> p_68838_.matches(lootcontext));
        }

        public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> entity) implements SimpleCriterionTrigger.SimpleInstance
        {
            public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337399_ -> p_337399_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(TriggerInstance::entity)).apply((Applicative)p_337399_, TriggerInstance::new));

            public static Criterion<TriggerInstance> madeEntityDance(EntityPredicate.Builder entity) {
                return DANCE_TRIGGER.createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)entity))));
            }

            public void validate(CriterionValidator validator) {
                validator.validateEntity(this.player(), ".player");
                validator.validateEntity(this.entity, ".entity");
            }

            public boolean matches(LootContext lootContext) {
                return this.entity.isEmpty() || this.entity.get().matches(lootContext);
            }
        }
    }

    public static class PacifyBearTrigger
    extends SimpleCriterionTrigger<TriggerInstance> {
        public Codec<TriggerInstance> codec() {
            return TriggerInstance.CODEC;
        }

        public void trigger(ServerPlayer player, Animal entity) {
            LootContext lootcontext = EntityPredicate.createContext((ServerPlayer)player, (Entity)entity);
            this.trigger(player, p_68838_ -> p_68838_.matches(lootcontext));
        }

        public record TriggerInstance(Optional<ContextAwarePredicate> player, Optional<ContextAwarePredicate> entity) implements SimpleCriterionTrigger.SimpleInstance
        {
            public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(p_337399_ -> p_337399_.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("entity").forGetter(TriggerInstance::entity)).apply((Applicative)p_337399_, TriggerInstance::new));

            public static Criterion<TriggerInstance> madeEntityDance(EntityPredicate.Builder entity) {
                return PACIFY_BEAR_TRIGGER.createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), Optional.of(EntityPredicate.wrap((EntityPredicate.Builder)entity))));
            }

            public void validate(CriterionValidator validator) {
                validator.validateEntity(this.player(), ".player");
                validator.validateEntity(this.entity, ".entity");
            }

            public boolean matches(LootContext lootContext) {
                return this.entity.isEmpty() || this.entity.get().matches(lootContext);
            }
        }
    }
}

