/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.init;

import javax.annotation.Nullable;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModPlacedFeatures;
import team.recrafted.blastfromthepast.init.ModSounds;

public class ModBiomes {
    public static final ResourceKey<Biome> FROSTBITE_FOREST = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"frostbite_forest"));
    public static final ResourceKey<Biome> FROSTBITE_RIVER = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"frostbite_river"));
    public static final int FROSTBITE_WATER_COLOR = 8764102;
    public static final int FROSTBITE_WATER_FOG_COLOR = 8764102;
    public static final int FROSTBITE_GRASS_COLOR = 6000247;
    public static final int FROSBITE_FOLIAGE_COLOR = 6000247;

    public static void register(BootstrapContext<Biome> biomeBootstrapContext) {
        HolderGetter holdergetter = biomeBootstrapContext.lookup(Registries.PLACED_FEATURE);
        HolderGetter worldCarvers = biomeBootstrapContext.lookup(Registries.CONFIGURED_CARVER);
        biomeBootstrapContext.register(FROSTBITE_FOREST, (Object)ModBiomes.frostbiteForest((HolderGetter<PlacedFeature>)holdergetter, worldCarvers));
        biomeBootstrapContext.register(FROSTBITE_RIVER, (Object)ModBiomes.frostbiteRiver((HolderGetter<PlacedFeature>)holdergetter, worldCarvers));
    }

    public static Biome frostbiteForest(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BURREL.get(), 8, 1, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SNOWDO.get(), 8, 2, 5)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GLACEROS.get(), 8, 3, 7)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SPEARTOOTH.get(), 8, 3, 6)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.PSYCHO_BEAR.get(), 8, 1, 1)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FROSTOMPER.get(), 8, 1, 6));
        BiomeGenerationSettings.Builder biomeGenBuilder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        biomeGenBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, ModPlacedFeatures.FROSTBITE_FOSSILS_UPPER);
        biomeGenBuilder.addFeature(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, ModPlacedFeatures.FROSTBITE_FOSSILS_LOWER);
        ModBiomes.globalOverworldGeneration(biomeGenBuilder);
        BiomeDefaultFeatures.addFerns((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomeGenBuilder);
        ModBiomes.addFrostbiteForestTrees(biomeGenBuilder);
        ModBiomes.addFrostbiteForestFlowers(biomeGenBuilder);
        biomeGenBuilder.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.PERMAFROST_BOULDERS);
        ModBiomes.addTarPits(biomeGenBuilder);
        BiomeDefaultFeatures.addTaigaGrass((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomeGenBuilder);
        BiomeDefaultFeatures.addSparseJungleMelons((BiomeGenerationSettings.Builder)biomeGenBuilder);
        biomeGenBuilder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PSYCHO_BERRY);
        return ModBiomes.biome(true, -0.5f, 0.4f, 8764102, 8764102, 6000247, 6000247, mobspawnsettings$builder, biomeGenBuilder);
    }

    private static void addTarPits(BiomeGenerationSettings.Builder biomeBuilder) {
        biomeBuilder.addFeature(GenerationStep.Decoration.LAKES, ModPlacedFeatures.TAR_PIT);
    }

    private static void addFrostbiteForestTrees(BiomeGenerationSettings.Builder biomegenerationsettings$builder) {
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.CEDAR_TREE);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.RUSTY_CEDAR_TREE);
    }

    private static void addFrostbiteForestFlowers(BiomeGenerationSettings.Builder biomegenerationsettings$builder) {
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.FROSTBITE_FOREST_FLOWERS);
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder generationSettings) {
        BiomeDefaultFeatures.addDefaultCarversAndLakes((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultCrystalFormations((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultMonsterRoom((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultUndergroundVariety((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addDefaultSprings((BiomeGenerationSettings.Builder)generationSettings);
        BiomeDefaultFeatures.addSurfaceFreezing((BiomeGenerationSettings.Builder)generationSettings);
    }

    private static Biome biome(boolean hasPrecipitation, float temperature, float downfall, int waterColor, int waterFogColor, @Nullable Integer grassColorOverride, @Nullable Integer foliageColorOverride, MobSpawnSettings.Builder mobSpawnSettings, BiomeGenerationSettings.Builder generationSettings) {
        BiomeSpecialEffects.Builder biomespecialeffects$builder = new BiomeSpecialEffects.Builder().waterColor(waterColor).waterFogColor(waterFogColor).fogColor(12638463).skyColor(ModBiomes.calculateSkyColor(temperature)).ambientMoodSound(AmbientMoodSettings.LEGACY_CAVE_SETTINGS).backgroundMusic(new Music(ModSounds.AURORA_FROLICS, 0, 12000, true));
        if (grassColorOverride != null) {
            biomespecialeffects$builder.grassColorOverride(grassColorOverride.intValue());
        }
        if (foliageColorOverride != null) {
            biomespecialeffects$builder.foliageColorOverride(foliageColorOverride.intValue());
        }
        return new Biome.BiomeBuilder().hasPrecipitation(hasPrecipitation).temperature(temperature).downfall(downfall).specialEffects(biomespecialeffects$builder.build()).mobSpawnSettings(mobSpawnSettings.build()).generationSettings(generationSettings.build()).build();
    }

    protected static int calculateSkyColor(float temperature) {
        float skyColor = temperature / 3.0f;
        skyColor = Mth.clamp((float)skyColor, (float)-1.0f, (float)1.0f);
        return Mth.hsvToRgb((float)(0.62222224f - skyColor * 0.05f), (float)(0.5f + skyColor * 0.1f), (float)1.0f);
    }

    public static Biome frostbiteRiver(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        MobSpawnSettings.Builder mobspawnsettings$builder = new MobSpawnSettings.Builder();
        mobspawnsettings$builder.addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.BURREL.get(), 8, 1, 2)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SNOWDO.get(), 8, 2, 5)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.GLACEROS.get(), 8, 3, 7)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SPEARTOOTH.get(), 8, 3, 6)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.PSYCHO_BEAR.get(), 8, 1, 1)).addSpawn(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntities.FROSTOMPER.get(), 8, 1, 6));
        BiomeGenerationSettings.Builder biomegenerationsettings$builder = new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers);
        ModBiomes.globalOverworldGeneration(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultOres((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultSoftDisks((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        ModBiomes.addFrostbiteForestTrees(biomegenerationsettings$builder);
        ModBiomes.addFrostbiteForestFlowers(biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultGrass((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultMushrooms((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        BiomeDefaultFeatures.addDefaultExtraVegetation((BiomeGenerationSettings.Builder)biomegenerationsettings$builder);
        biomegenerationsettings$builder.addFeature(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.CHILLY_MOSS);
        return ModBiomes.biome(true, -0.5f, 0.5f, 8764102, 8764102, 6000247, 6000247, mobspawnsettings$builder, biomegenerationsettings$builder);
    }
}

