/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.events;

import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.block.BearTrapBlockEntity;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;
import team.recrafted.blastfromthepast.entity.HollowEntity;
import team.recrafted.blastfromthepast.entity.TarArrow;
import team.recrafted.blastfromthepast.init.ModBiomes;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModMobEffects;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.network.PsychoedEffectPayload;
import team.recrafted.blastfromthepast.util.EntityHelper;

@EventBusSubscriber(modid="blastfromthepast", bus=EventBusSubscriber.Bus.GAME)
public class NeoForgeEvents {
    public static Predicate<BlockState> PERMAFROST_PREDICATE = state -> {
        Block block = state.getBlock();
        if (block == Blocks.STONE) {
            return true;
        }
        if (state.isAir()) {
            return false;
        }
        return block == Blocks.DIORITE || block == Blocks.ANDESITE || block == Blocks.GRANITE || block == Blocks.COAL_ORE || block == Blocks.COPPER_ORE || block == Blocks.DIAMOND_ORE || block == Blocks.EMERALD_ORE || block == Blocks.GOLD_ORE || block == Blocks.IRON_ORE || block == Blocks.LAPIS_ORE || block == Blocks.REDSTONE_ORE;
    };
    public static Function<BlockState, BlockState> PERMAFROST_FUNCTION = state -> {
        Block block = state.getBlock();
        if (block == Blocks.STONE) {
            return ((Block)ModBlocks.PERMAFROST.BLOCK.get()).defaultBlockState();
        }
        ResourceLocation location = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (block == Blocks.GRANITE) {
            return Blocks.ICE.defaultBlockState();
        }
        if (block == Blocks.DIORITE) {
            return Blocks.PACKED_ICE.defaultBlockState();
        }
        if (block == Blocks.ANDESITE) {
            return Blocks.BLUE_ICE.defaultBlockState();
        }
        Block newBlock = (Block)BuiltInRegistries.BLOCK.get(BlastFromThePast.location("permafrost_" + location.getPath()));
        if (newBlock != Blocks.AIR) {
            return newBlock.defaultBlockState();
        }
        return state;
    };

    @SubscribeEvent
    public static void chunkLoad(ChunkEvent.Load event) {
        if (!event.isNewChunk()) {
            return;
        }
        if (event.getChunk().getNoiseBiome(0, 0, 0).is(ModBiomes.FROSTBITE_RIVER) || event.getChunk().getNoiseBiome(0, 0, 0).is(ModBiomes.FROSTBITE_FOREST)) {
            event.getChunk().findBlocks(PERMAFROST_PREDICATE, (pos, state) -> event.getLevel().setBlock(pos, PERMAFROST_FUNCTION.apply((BlockState)state), 4, 0));
        }
    }

    @SubscribeEvent
    public static void playerInteractEvent(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        if (entity instanceof GlacerosEntity) {
            GlacerosEntity glaceros = (GlacerosEntity)entity;
            if (event.getItemStack().is(Items.SHEARS) && !glaceros.isBaby() && !glaceros.isSheared()) {
                glaceros.setSheared(true);
                glaceros.antlerGrowCooldown = 1000 + glaceros.getRandom().nextInt(300);
                if (!event.getEntity().isCreative()) {
                    event.getEntity().getItemInHand(event.getHand()).setDamageValue(1);
                }
                event.getLevel().playSound(event.getTarget(), event.getPos(), (SoundEvent)ModSounds.GLACEROS_SHEAR.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                event.getEntity().swing(event.getHand());
                ItemStack antlers = new ItemStack((ItemLike)glaceros.getVariant().getAntlerItem(), 2);
                event.getLevel().addFreshEntity((Entity)new ItemEntity(event.getLevel(), glaceros.getX(), glaceros.getY() + 0.5, glaceros.getZ(), antlers));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (player.hasEffect(ModMobEffects.PSYCHOD)) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PsychoedEffectPayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (EntityHelper.shouldCreateHollow(player)) {
                ItemStack idol = EntityHelper.getIdolOfRetrievalInHand(player);
                if (idol != null) {
                    CriteriaTriggers.CONSUME_ITEM.trigger(player, idol);
                    idol.shrink(1);
                }
                HollowEntity hollow = HollowEntity.create(player);
                player.serverLevel().addFreshEntity((Entity)hollow);
            }
        }
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        if (event.getRayTraceResult().getType() == HitResult.Type.BLOCK && event.getProjectile() instanceof TarArrow) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getHitVec().getBlockPos();
        Level level = event.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof BearTrapBlockEntity) {
            BearTrapBlockEntity blockEntity2 = (BearTrapBlockEntity)blockEntity;
            blockEntity2.interact(level, pos, event.getEntity());
        }
    }

    @SubscribeEvent
    public static void effectAdded(MobEffectEvent.Added event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getEffectInstance().is(ModMobEffects.PSYCHOD)) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PsychoedEffectPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void effectRemoved(MobEffectEvent.Remove event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getEffect().is(ModMobEffects.PSYCHOD)) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PsychoedEffectPayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void effectExpired(MobEffectEvent.Expired event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (event.getEffectInstance().is(ModMobEffects.PSYCHOD)) {
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PsychoedEffectPayload(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().hasEffect(ModMobEffects.PSYCHOD)) {
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new PsychoedEffectPayload(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

