/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.events;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.RegisterEvent;
import team.recrafted.blastfromthepast.block.BFTPWoodGroup;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModCriteriaTriggers;
import team.recrafted.blastfromthepast.init.ModDecoratedPatterns;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.network.BearGloveWallAnimPayload;
import team.recrafted.blastfromthepast.network.ClientPayloadHandler;
import team.recrafted.blastfromthepast.network.FrostomperCollidePayload;
import team.recrafted.blastfromthepast.network.PsychoedEffectPayload;
import team.recrafted.blastfromthepast.network.RiddenEntityPayload;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.network.ServerPayloadHandler;
import team.recrafted.blastfromthepast.util.ClientUtils;
import team.recrafted.blastfromthepast.worldgen.biome.BFTPOverworldRegion;
import terrablender.api.Region;
import terrablender.api.Regions;

@EventBusSubscriber(modid="blastfromthepast", bus=EventBusSubscriber.Bus.MOD)
public class CommonNeoEvents {
    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModDecoratedPatterns::expandVanillaPottery);
        CommonNeoEvents.registerFlammables();
        event.enqueueWork(() -> Regions.register((Region)new BFTPOverworldRegion(ResourceLocation.fromNamespaceAndPath((String)"blastfromthepast", (String)"overworld"), 1)));
    }

    @SubscribeEvent
    public static void registerEvent(RegisterEvent event) {
        if (event.getRegistry() == BuiltInRegistries.TRIGGER_TYPES) {
            ModCriteriaTriggers.init();
        }
    }

    @SubscribeEvent
    public static void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(RiddenEntityPayload.TYPE, RiddenEntityPayload.STREAM_CODEC, ServerPayloadHandler::handleRiddenEntityPayload);
        registrar.playToServer(FrostomperCollidePayload.TYPE, FrostomperCollidePayload.STREAM_CODEC, ServerPayloadHandler::handleFroststomperCollidePayload);
        registrar.commonBidirectional(BearGloveWallAnimPayload.TYPE, BearGloveWallAnimPayload.STREAM_CODEC, (payload, context) -> {
            if (context.flow().isClientbound()) {
                ClientPayloadHandler.handleBearGloveAnim(payload);
            } else {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)context.player(), (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (payload.shouldPlay()) {
                context.player().level().playSound(null, context.player().blockPosition(), (SoundEvent)ModSounds.WALL_GRAB.get(), SoundSource.PLAYERS, 1.0f, 1.0f + (float)context.player().getRandom().nextIntBetweenInclusive(-5, 5) / 100.0f);
            }
        });
        registrar.playToClient(ScreenShakePayload.TYPE, ScreenShakePayload.STREAM_CODEC, (payload, context) -> ClientPayloadHandler.handleScreenShake(payload));
        registrar.playToClient(PsychoedEffectPayload.TYPE, PsychoedEffectPayload.STREAM_CODEC, (payload, context) -> ClientUtils.shouldApplyPsychoedShader(payload.shouldApply()));
    }

    @SubscribeEvent
    public static void registerSpawnPlacement(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)ModEntities.BURREL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.FROSTOMPER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.SNOWDO.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.GLACEROS.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.PSYCHO_BEAR.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        event.register((EntityType)ModEntities.SPEARTOOTH.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::checkAnimalSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static void registerFlammables() {
        CommonNeoEvents.registerWoodGroupFlammables(ModBlocks.CEDAR);
        CommonNeoEvents.flammableBlock((Block)ModBlocks.SAPPY_CEDAR_LOG.get(), 5, 6);
    }

    public static void registerWoodGroupFlammables(BFTPWoodGroup woodGroup) {
        CommonNeoEvents.flammableBlock((Block)woodGroup.LEAVES.get(), 5, 30);
        CommonNeoEvents.flammableBlock((Block)woodGroup.BLOCK.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.DOOR.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.SLAB.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.STAIRS.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.STRIPPED_LOG.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.LOG.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.STRIPPED_WOOD.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.WOOD.get(), 5, 5);
        CommonNeoEvents.flammableBlock((Block)woodGroup.FENCE.get(), 5, 20);
        CommonNeoEvents.flammableBlock((Block)woodGroup.FENCE_GATE.get(), 5, 20);
    }

    public static void flammableBlock(Block block, int flameOdds, int burnOdds) {
        FireBlock fire = (FireBlock)Blocks.FIRE;
        fire.setFlammable(block, flameOdds, burnOdds);
    }
}

