/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.speartooth.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.entity.speartooth.SpeartoothEntity;

public class SpeartoothPounceTargetGoal
extends Goal {
    private final SpeartoothEntity tiger;
    private LivingEntity target;
    private final float yd;
    private int pounceTime;

    public SpeartoothPounceTargetGoal(SpeartoothEntity mob, float yd) {
        this.tiger = mob;
        this.yd = yd;
        this.setFlags(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!(this.tiger.shouldRetreat() || this.tiger.isBaby() || this.tiger.hasControllingPassenger())) {
            this.target = this.tiger.getTarget();
            if (this.target == null) {
                return false;
            }
            if (!this.target.getUUID().equals(this.tiger.lastPouncedAt) || this.tiger.level().getGameTime() - this.tiger.lastPounceTime > 140L) {
                double distance = this.tiger.distanceToSqr((Entity)this.target);
                if (!(distance < 7.0) && !(distance > 50.0)) {
                    return this.tiger.onGround() && this.tiger.getRandom().nextInt(SpeartoothPounceTargetGoal.reducedTickDelay((int)5)) == 0;
                }
                return false;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.tiger.isWithinMeleeAttackRange(this.target)) {
            this.tiger.doHurtTarget((Entity)this.target);
            return false;
        }
        return this.pounceTime++ < 20 && !this.tiger.onGround();
    }

    public void start() {
        this.tiger.setState(SpeartoothEntity.State.LUNGE);
        this.tiger.setTexture(SpeartoothEntity.Texture.AGGRESSIVE);
        Vec3 vec3 = this.tiger.getDeltaMovement();
        Vec3 vec31 = new Vec3(this.target.getX() - this.tiger.getX(), 0.0, this.target.getZ() - this.tiger.getZ());
        if (vec31.lengthSqr() > 1.0E-7) {
            vec31 = vec31.normalize().scale(0.5).add(vec3.scale(0.3));
        }
        vec31 = vec31.scale(2.0);
        this.tiger.setDeltaMovement(vec31.x, this.yd, vec31.z);
        this.tiger.lastPouncedAt = this.target.getUUID();
        this.tiger.lastPounceTime = this.tiger.level().getGameTime();
        this.pounceTime = 0;
    }

    public void stop() {
        this.tiger.setState(SpeartoothEntity.State.IDLE);
        super.stop();
    }
}

