/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.speartooth;

import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.GlacerosEntity;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.entity.ai.goal.CustomPanicGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.pack.PackHurtByTargetGoal;
import team.recrafted.blastfromthepast.entity.ai.goal.roar.RoarAtTargetGoal;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.entity.misc.StateValue;
import team.recrafted.blastfromthepast.entity.pack.EntityPack;
import team.recrafted.blastfromthepast.entity.pack.EntityPackAgeableMobData;
import team.recrafted.blastfromthepast.entity.pack.EntityPackHolder;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothBiteAttackGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothPounceTargetGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothRetreatGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothSleepGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothStalkTargetGoal;
import team.recrafted.blastfromthepast.entity.speartooth.ai.SpeartoothTigerIdleGoal;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModDataSerializers;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.init.ModSounds;
import team.recrafted.blastfromthepast.network.ScreenShakePayload;
import team.recrafted.blastfromthepast.util.EntityHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpeartoothEntity
extends TamableAnimal
implements ComplexAnimal,
GeoEntity,
Roaring,
EntityPackHolder<SpeartoothEntity> {
    private static final EntityDimensions BABY_DIMENSIONS = ((EntityType)ModEntities.SPEARTOOTH.get()).getDimensions().scale(0.5f).withEyeHeight(0.55f);
    protected static final EntityDataAccessor<State> STATE = SynchedEntityData.defineId(SpeartoothEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.SPEARTOOTH_STATE.get()));
    protected static final EntityDataAccessor<Texture> TEXTURE = SynchedEntityData.defineId(SpeartoothEntity.class, (EntityDataSerializer)((EntityDataSerializer)ModDataSerializers.SPEARTOOTH_TEXTURE.get()));
    public static final RawAnimation IDLE = RawAnimation.begin().then("animation.speartooth.idle", Animation.LoopType.DEFAULT);
    public static final RawAnimation SLEEP = RawAnimation.begin().then("animation.speartooth.sleep", Animation.LoopType.DEFAULT);
    public static final RawAnimation COLD = RawAnimation.begin().then("animation.speartooth.cold", Animation.LoopType.DEFAULT);
    public static final RawAnimation DANCE = RawAnimation.begin().then("animation.speartooth.dance", Animation.LoopType.DEFAULT);
    public static final RawAnimation NOISE = RawAnimation.begin().then("animation.speartooth.noise", Animation.LoopType.DEFAULT);
    public static final RawAnimation EAR = RawAnimation.begin().then("animation.speartooth.ear", Animation.LoopType.DEFAULT);
    public static final RawAnimation STRETCH = RawAnimation.begin().then("animation.speartooth.stretch", Animation.LoopType.DEFAULT);
    public static final RawAnimation SIT = RawAnimation.begin().then("animation.speartooth.sit", Animation.LoopType.DEFAULT);
    public static final RawAnimation STALK = RawAnimation.begin().then("animation.speartooth.stalk", Animation.LoopType.DEFAULT);
    public static final RawAnimation BITE = RawAnimation.begin().then("animation.speartooth.attack", Animation.LoopType.DEFAULT);
    public static final RawAnimation ROAR = RawAnimation.begin().then("animation.speartooth.roar", Animation.LoopType.DEFAULT);
    public static final RawAnimation LUNGE = RawAnimation.begin().then("animation.speartooth.lunge", Animation.LoopType.DEFAULT);
    public static final RawAnimation WALK = RawAnimation.begin().then("animation.speartooth.walk", Animation.LoopType.DEFAULT);
    public static final RawAnimation RUN = RawAnimation.begin().then("animation.speartooth.run", Animation.LoopType.DEFAULT);
    @org.jetbrains.annotations.Nullable
    public UUID lastPouncedAt;
    public long lastPounceTime;
    public long lastStalkTime;
    public long lastRoarTime;
    public LivingEntity lastTarget;
    private int roarTimer;
    private int huntCooldown;
    private boolean party;
    @Nullable
    private BlockPos jukebox;
    private EntityPack<SpeartoothEntity> pack;
    private Goal huntPlayerGoal;
    private Goal huntGlacerosGoal;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SpeartoothEntity(EntityType<? extends TamableAnimal> entityType, Level level) {
        super(entityType, level);
        this.xpReward = 5;
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(STATE, (Object)State.IDLE);
        builder.define(TEXTURE, (Object)Texture.DEFAULT);
    }

    public void registerGoals() {
        super.registerGoals();
        int i = 0;
        this.goalSelector.addGoal(i++, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(i++, (Goal)new SpeartoothSleepGoal(this));
        this.goalSelector.addGoal(i++, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(i++, (Goal)new SpeartoothRetreatGoal(this, 1.7f, 1.9f));
        this.goalSelector.addGoal(i++, new RoarAtTargetGoal<SpeartoothEntity>(this, 3.0));
        SpeartoothPounceTargetGoal pounceGoal = new SpeartoothPounceTargetGoal(this, 0.5f);
        this.goalSelector.addGoal(i++, (Goal)pounceGoal);
        this.goalSelector.addGoal(i++, (Goal)new SpeartoothStalkTargetGoal(this, pounceGoal, 30.0f, 4.0f));
        this.goalSelector.addGoal(i++, (Goal)new SpeartoothBiteAttackGoal(this, 2.0, false));
        this.goalSelector.addGoal(i++, new CustomPanicGoal<SpeartoothEntity>(this, p -> true, 2.0, EntityHelper::getPanicInducingDamageTypes));
        this.goalSelector.addGoal(i++, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(i++, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.25, 10.0f, 2.0f));
        this.goalSelector.addGoal(i++, (Goal)new TemptGoal((PathfinderMob)this, 1.25, this::isTemptItem, false));
        this.goalSelector.addGoal(i++, (Goal)new SpeartoothTigerIdleGoal(this));
        this.goalSelector.addGoal(i++, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(i++, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.goalSelector.addGoal(i++, (Goal)new RandomLookAroundGoal((Mob)this));
        int t = 0;
        this.targetSelector.addGoal(t++, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(t++, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(t++, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(t++, new PackHurtByTargetGoal<SpeartoothEntity>(this, Predicate.not(AgeableMob::isBaby), AgeableMob::isBaby, new Class[0]));
        this.huntGlacerosGoal = new NearestAttackableTargetGoal((Mob)this, GlacerosEntity.class, false);
        this.huntPlayerGoal = new NearestAttackableTargetGoal((Mob)this, Player.class, true);
        this.targetSelector.addGoal(t, this.huntGlacerosGoal);
        this.targetSelector.addGoal(t, this.huntPlayerGoal);
    }

    private boolean isTemptItem(ItemStack itemStack) {
        return !this.isTame() && !this.isBaby() && itemStack.is(ModBlocks.BEAST_CHOPS.asItem());
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return this.isBaby() ? BABY_DIMENSIONS : super.getDefaultDimensions(pose);
    }

    public boolean shouldRetreat() {
        return this.getHealth() < this.getMaxHealth() / 4.0f;
    }

    public void setTarget(@org.jetbrains.annotations.Nullable LivingEntity target) {
        if (target != null && !this.isTame()) {
            if (this.huntCooldown > 0) {
                return;
            }
            this.huntCooldown = 6000;
        }
        if (!this.shouldRetreat() || target == null) {
            super.setTarget(target);
        }
    }

    public void setTame(boolean tame, boolean applyTamingSideEffects) {
        super.setTame(tame, applyTamingSideEffects);
        if (tame) {
            this.targetSelector.removeGoal(this.huntGlacerosGoal);
            this.targetSelector.removeGoal(this.huntPlayerGoal);
        }
    }

    public void tick() {
        super.tick();
        State state = this.getState();
        if (!this.level().isClientSide) {
            if (this.lastTarget != null && (this.lastTarget.isRemoved() || !this.hasLineOfSight((Entity)this.lastTarget) && this.lastTarget != this.getTarget())) {
                this.lastTarget = null;
            }
            --this.huntCooldown;
            if (this.getTexture() == Texture.STALKING && state != State.STALK) {
                this.setTexture(Texture.DEFAULT);
            }
            if (state == State.ROAR) {
                --this.roarTimer;
                if (this.roarTimer <= 0) {
                    this.setRoaring(false);
                }
            }
        }
    }

    public boolean isIdle() {
        State state = this.getState();
        return state == State.IDLE || state == State.NOISE || state == State.EAR || state == State.STRETCH || state == State.COLD;
    }

    public boolean isFood(ItemStack itemStack) {
        return itemStack.is(ItemTags.MEAT);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        SpeartoothEntity speartooth = (SpeartoothEntity)((EntityType)ModEntities.SPEARTOOTH.get()).create((Level)serverLevel);
        if (speartooth == null) {
            return null;
        }
        speartooth.setOwnerUUID(this.getOwnerUUID());
        speartooth.setTame(true, true);
        speartooth.setPack(this.pack);
        return speartooth;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Animal.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, (double)0.22f);
        builder = builder.add(Attributes.MAX_HEALTH, 30.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 64.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 6.0);
        return builder;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (!this.level().isClientSide) {
            if (this.isTame()) {
                if (hand == InteractionHand.MAIN_HAND && this.isOwnedBy((LivingEntity)player) && this.isSleeping()) {
                    this.setSleeping(false);
                    this.setOrderedToSit(false);
                    return InteractionResult.SUCCESS_NO_ITEM_USED;
                }
                if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                    FoodProperties foodproperties = itemstack.getFoodProperties((LivingEntity)this);
                    float f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    this.heal(2.0f * f);
                    itemstack.consume(1, (LivingEntity)player);
                    this.gameEvent((Holder)GameEvent.EAT);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                if (this.isBaby() || itemstack.is(ModItems.RAW_VENISON)) {
                    return super.mobInteract(player, hand);
                }
                if (this.isOwnedBy((LivingEntity)player) && hand == InteractionHand.MAIN_HAND) {
                    this.setOrderedToSit(!this.isOrderedToSit());
                    this.jumping = false;
                    this.navigation.stop();
                    this.setTarget(null);
                    return InteractionResult.SUCCESS_NO_ITEM_USED;
                }
            } else {
                if (itemstack.is(ModBlocks.BEAST_CHOPS.asItem())) {
                    itemstack.consume(1, (LivingEntity)player);
                    this.tame(player);
                    this.navigation.stop();
                    this.setTarget(null);
                    this.setOrderedToSit(true);
                    this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                }
                return super.mobInteract(player, hand);
            }
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    public boolean wantsToAttack(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof Creeper || target instanceof Ghast || target instanceof ArmorStand)) {
            if (!(target instanceof SpeartoothEntity)) {
                TamableAnimal tamable;
                AbstractHorse horse;
                if (target instanceof Player) {
                    Player ownerPlayer;
                    Player playerTarget = (Player)target;
                    if (owner instanceof Player && !(ownerPlayer = (Player)owner).canHarmPlayer(playerTarget)) {
                        return false;
                    }
                }
                if (target instanceof AbstractHorse && (horse = (AbstractHorse)target).isTamed()) {
                    return false;
                }
                return !(target instanceof TamableAnimal) || !(tamable = (TamableAnimal)target).isTame();
            }
            SpeartoothEntity speartooth = (SpeartoothEntity)target;
            return !speartooth.isTame() || speartooth.getOwner() != owner;
        }
        return false;
    }

    public void setInSittingPose(boolean sitting) {
        super.setInSittingPose(sitting);
        this.setState(sitting ? State.SIT : State.IDLE);
    }

    public void setOrderedToSit(boolean orderedToSit) {
        super.setOrderedToSit(orderedToSit);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @org.jetbrains.annotations.Nullable SpawnGroupData spawnGroupData) {
        if (spawnGroupData == null) {
            spawnGroupData = new SpeartoothGroupData(BlastFromThePast.getUniversalEntityPacks(level.getLevel().getServer()).createFreshPack(), true);
        }
        if (spawnGroupData instanceof SpeartoothGroupData) {
            SpeartoothGroupData speartoothGroupData = (SpeartoothGroupData)spawnGroupData;
            speartoothGroupData.addPackMember((Mob)this);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean isLookingAtMe(LivingEntity pEntity) {
        Vec3 vec3 = pEntity.getViewVector(1.0f).normalize();
        Vec3 vec31 = new Vec3(this.getX() - pEntity.getX(), this.getEyeY() - pEntity.getEyeY(), this.getZ() - pEntity.getZ());
        double d0 = vec31.length();
        double d1 = vec3.dot(vec31 = vec31.normalize());
        return d1 > 1.0 - 0.025 / d0 && pEntity.hasLineOfSight((Entity)this);
    }

    public Texture getTexture() {
        return (Texture)this.entityData.get(TEXTURE);
    }

    public void setTexture(Texture texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public State getState() {
        return (State)this.entityData.get(STATE);
    }

    public void setState(State state) {
        if (state.texture() == Texture.AGGRESSIVE && this.isBaby()) {
            BlastFromThePast.LOGGER.warn("Baby speartooth cannot have an aggressive state!");
            new Exception().printStackTrace();
            return;
        }
        this.entityData.set(STATE, (Object)state);
        if (state.texture() != null) {
            this.setTexture(state.texture());
        }
    }

    public void aiStep() {
        if (this.isSleeping() || this.isImmobile()) {
            this.jumping = false;
            this.xxa = 0.0f;
            this.zza = 0.0f;
        }
        if (this.jukebox == null || !this.jukebox.closerToCenterThan((Position)this.position(), 7.0) || !this.level().getBlockState(this.jukebox).is(Blocks.JUKEBOX)) {
            this.party = false;
            this.jukebox = null;
        }
        super.aiStep();
    }

    public void setRecordPlayingNearby(BlockPos pos, boolean isPartying) {
        this.jukebox = pos;
        this.party = isPartying;
    }

    @Override
    public void tryToSit() {
        if (!this.isInWater()) {
            this.setZza(0.0f);
            this.setState(State.SIT);
            this.setSitting(true);
        }
    }

    @Override
    public boolean isSitting() {
        return this.getState() == State.SIT;
    }

    @Override
    public void setSitting(boolean sitting) {
        this.setState(sitting ? State.SIT : State.IDLE);
    }

    @Override
    @org.jetbrains.annotations.Nullable
    public EntityPack<SpeartoothEntity> getPack() {
        return this.pack;
    }

    @Override
    public void setPack(@org.jetbrains.annotations.Nullable EntityPack<SpeartoothEntity> pack) {
        this.pack = pack;
    }

    @Override
    public boolean canPerformAction() {
        return !this.isEating() && !this.isSitting() && !this.isSleeping();
    }

    @Override
    public boolean isEating() {
        return this.getState() == State.EAT_OFF_GROUND;
    }

    @Override
    public void setEating(boolean eating) {
        this.setState(eating ? State.EAT_OFF_GROUND : State.IDLE);
    }

    @Override
    public ItemStack getItemInMouth() {
        return ItemStack.EMPTY;
    }

    @Override
    public void putItemInMouth(ItemStack item, boolean guaranteeDrop) {
    }

    @Override
    public boolean wantsMoreFood() {
        return false;
    }

    @Override
    public void gotFood(int ticks) {
    }

    @Override
    public boolean isWantedFood(ItemStack stack) {
        return false;
    }

    @Override
    public void takeFood(ItemStack stack) {
    }

    @Override
    public boolean isSleepingFlag() {
        return this.getState() == State.SLEEP;
    }

    public boolean isSleeping() {
        return this.isSleepingFlag();
    }

    @Override
    public void setSleeping(boolean sleeping) {
        this.setState(sleeping ? State.SLEEP : State.IDLE);
    }

    @Override
    public void prepareToStartSleeping() {
        this.makeSound((SoundEvent)ModSounds.SPEARTOOTH_YAWN.get());
        this.setSleeping(true);
    }

    @Override
    public boolean canSleep() {
        if (this.isTame() && !this.isOrderedToSit() && !this.isSleeping()) {
            return false;
        }
        return this.level().isNight() && !this.isInPowderSnow && this.getLastDamageSource() == null && !this.isInPowderSnow && this.getTarget() == null && this.getLastDamageSource() == null;
    }

    @Override
    public boolean shouldFindShelter(boolean urgent) {
        return false;
    }

    @Override
    public void clearStates() {
        this.setState(State.IDLE);
        this.setTexture(Texture.DEFAULT);
        this.setSitting(false);
        this.setEating(false);
        this.setSleeping(false);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)ModSounds.SPEARTOOTH_IDLE.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getDeathSound() {
        return (SoundEvent)ModSounds.SPEARTOOTH_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)ModSounds.SPEARTOOTH_HURT.get();
    }

    public boolean hurt(DamageSource source, float amount) {
        this.jukebox = null;
        this.party = false;
        return super.hurt(source, amount);
    }

    @Override
    public void roarIfPossible() {
        if (this.canRoar()) {
            this.setRoaring(true);
            this.setState(State.ROAR);
            this.roarTimer = State.ROAR.duration();
            this.lastRoarTime = this.level().getGameTime();
            this.makeSound((SoundEvent)ModSounds.SPEARTOOTH_ROAR.get());
            for (Player player : this.level().getEntitiesOfClass(Player.class, new AABB(this.blockPosition()).inflate((double)(((SoundEvent)ModSounds.SPEARTOOTH_ROAR.get()).getRange(this.getSoundVolume()) - 1.0f)))) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new ScreenShakePayload(20.0f, 60), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Override
    public boolean canRoar() {
        return !this.isBaby() && this.getState() != State.ROAR && this.lastRoarTime + 400L < this.level().getGameTime();
    }

    @Override
    public boolean isRoaring() {
        return this.getState() == State.ROAR;
    }

    @Override
    public void setRoaring(boolean roaring) {
        this.setState(roaring ? State.ROAR : State.IDLE);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "main", 5, state1 -> {
            State state = this.getState();
            if (state == State.SLEEP) {
                return state1.setAndContinue(SLEEP);
            }
            if (this.isBaby()) {
                if (state == State.COLD) {
                    return state1.setAndContinue(COLD);
                }
            } else {
                if (state == State.DANCE) {
                    return state1.setAndContinue(DANCE);
                }
                if (state == State.NOISE) {
                    return state1.setAndContinue(NOISE);
                }
                if (state == State.EAR) {
                    return state1.setAndContinue(EAR);
                }
                if (state == State.STRETCH) {
                    return state1.setAndContinue(STRETCH);
                }
                if (state == State.SIT) {
                    return state1.setAndContinue(SIT);
                }
                if (state == State.STALK) {
                    return state1.setAndContinue(STALK);
                }
                if (state == State.BITE) {
                    return state1.setAndContinue(BITE);
                }
                if (state == State.ROAR) {
                    return state1.setAndContinue(ROAR);
                }
                if (state == State.LUNGE) {
                    return state1.setAndContinue(LUNGE);
                }
            }
            if (state1.isMoving()) {
                if (!this.isBaby() && this.getDeltaMovement().length() > 5.5) {
                    return state1.setAndContinue(RUN);
                }
                return state1.setAndContinue(WALK);
            }
            if (this.party && !this.isBaby()) {
                return state1.setAndContinue(DANCE);
            }
            if (state != State.COLD && !state1.isMoving() && this.onGround()) {
                return state1.setAndContinue(IDLE);
            }
            return PlayState.STOP;
        }));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static enum State implements StateValue
    {
        IDLE(0),
        NOISE(1),
        EAR(2, 15),
        ROAR(3, 40),
        STRETCH(4, 45),
        GRIDDY(5),
        EAT_OFF_GROUND(6, 40),
        LUNGE(7, 15),
        RUN(8),
        STALK(9, 40, Texture.STALKING),
        DANCE(10, 30),
        WALK(11),
        SIT(12),
        SLEEP(13, Texture.SLEEPING),
        BITE(14, 15),
        COLD(15, 100);

        private final int id;
        private final int duration;
        @org.jetbrains.annotations.Nullable
        private final Texture texture;

        private State(int id) {
            this.id = id;
            this.duration = -1;
            this.texture = null;
        }

        private State(int id, int length) {
            this.id = id;
            this.duration = length;
            this.texture = null;
        }

        private State(int id, int length, Texture texture) {
            this.id = id;
            this.duration = length;
            this.texture = texture;
        }

        private State(int id, Texture texture) {
            this.id = id;
            this.duration = -1;
            this.texture = texture;
        }

        @Override
        public int id() {
            return this.id;
        }

        public int duration() {
            return this.duration;
        }

        @org.jetbrains.annotations.Nullable
        public Texture texture() {
            return this.texture;
        }
    }

    public static enum Texture implements StateValue
    {
        DEFAULT(0, null),
        AGGRESSIVE(1, "aggressive"),
        SLEEPING(2, "sleeping"),
        STALKING(3, "stalking");

        private final int id;
        @org.jetbrains.annotations.Nullable
        private final String suffix;
        private static final String PATH = "textures/entity/%sspeartooth%s.png";
        private static final BiFunction<Texture, Boolean, ResourceLocation> LOCATION;

        private Texture(int id, String suffix) {
            this.id = id;
            this.suffix = suffix;
        }

        @Override
        public int id() {
            return this.id;
        }

        @org.jetbrains.annotations.Nullable
        public String suffix() {
            return this.suffix;
        }

        public ResourceLocation textureId(boolean isBaby) {
            return LOCATION.apply(this, isBaby);
        }

        static {
            LOCATION = Util.memoize((texture, baby) -> BlastFromThePast.location(PATH.formatted(baby != false ? "baby_" : "", texture.suffix == null ? "" : "_" + texture.suffix)));
        }
    }

    protected static class SpeartoothGroupData
    extends EntityPackAgeableMobData<SpeartoothEntity> {
        public SpeartoothGroupData(EntityPack<SpeartoothEntity> entityPack, boolean shouldSpawnBaby) {
            super(entityPack, shouldSpawnBaby);
        }
    }
}

