/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.misc;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public interface AnimatedAttacker<T extends Mob, A extends AttackType<T, A>> {
    public void setActiveAttackType(@Nullable A var1);

    @Nullable
    public A getActiveAttackType();

    public A selectAttackTypeForTarget(@Nullable LivingEntity var1);

    public static class AttackTicker<T extends Mob, A extends AttackType<T, A>> {
        private final T attacker;
        private int tick;

        public AttackTicker(T attacker) {
            this.attacker = attacker;
        }

        public void reset() {
            this.tick = 0;
        }

        public void tick() {
            Object activeAttackType = ((AnimatedAttacker)this.attacker).getActiveAttackType();
            if (activeAttackType != null) {
                if (activeAttackType.hasAttackPointAt(this.tick)) {
                    activeAttackType.executeAttackPoint(this.attacker, this.tick);
                }
                if (!this.attacker.level().isClientSide && activeAttackType.isFinished(this.attacker, this.tick)) {
                    if (DebugFlags.DEBUG_ANIMATED_ATTACK) {
                        BlastFromThePast.LOGGER.info("Finished attack {} for {}", activeAttackType, this.attacker);
                    }
                    ((AnimatedAttacker)this.attacker).setActiveAttackType(null);
                }
            }
            if ((activeAttackType = ((AnimatedAttacker)this.attacker).getActiveAttackType()) != null && !activeAttackType.isFinished(this.attacker, this.tick)) {
                ++this.tick;
            }
        }

        public int get() {
            return this.tick;
        }
    }

    public static interface AttackType<T extends Mob, A extends AttackType<T, A>> {
        public int getAttackPoint();

        public int getAttackDuration();

        public Vec3 getAttackSize();

        public float getAttackDamage();

        public float getAttackKnockback();

        default public void executeAttackPoint(T attacker, int attackTicker) {
            Vec3 attackSize = this.getAttackSize().scale((double)attacker.getScale());
            AABB attackBounds = HitboxHelper.createHitboxRelativeToFront(attacker, attackSize.x(), attackSize.y(), attackSize.z());
            EntityHelper.hitTargetsWithAOEAttack(attacker, attackBounds, this.getAttackDamage(), this.getAttackKnockback(), true);
        }

        default public boolean isTargetCloseEnoughToStart(T attacker, LivingEntity target) {
            Vec3 startAttackSize = this.getAttackSize().scale((double)attacker.getScale()).multiply(1.0, 1.0, 0.5);
            AABB startAttackBounds = HitboxHelper.createHitboxRelativeToFront(attacker, startAttackSize.x(), startAttackSize.y(), startAttackSize.z());
            return startAttackBounds.intersects(target.getHitbox());
        }

        default public boolean hasAttackPointAt(int attackTicker) {
            return this.getAttackPoint() == attackTicker;
        }

        default public boolean blocksMovementInput() {
            return true;
        }

        default public boolean blocksWalkAnimation() {
            return this.blocksMovementInput();
        }

        default public boolean blocksRotationInput() {
            return true;
        }

        default public boolean blocksBodyRotation() {
            return this.blocksRotationInput();
        }

        default public boolean blocksHeadRotation() {
            return this.blocksRotationInput();
        }

        default public boolean blocksLookAnimation() {
            return this.blocksHeadRotation();
        }

        default public boolean isFinished(T attacker, int attackTicker) {
            return attackTicker >= this.getAttackDuration();
        }
    }
}

