/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.boats;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootTable;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.entity.boats.BFTPBoat;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;

public class BFTPChestBoat
extends BFTPBoat
implements HasCustomInventoryScreen,
ContainerEntity {
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    private @Nullable ResourceKey<LootTable> lootTable;
    private long lootTableSeed;

    public BFTPChestBoat(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BFTPChestBoat(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends Boat>)((EntityType)ModEntities.BFTPCHEST_BOAT.get()), pLevel);
        this.setPos(pX, pY, pZ);
        this.xo = pX;
        this.yo = pY;
        this.zo = pZ;
    }

    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    public void setLootTableSeed(long seed) {
        this.lootTableSeed = seed;
    }

    protected float getSinglePassengerXOffset() {
        return 0.15f;
    }

    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.addChestVehicleSaveData(pCompound, (HolderLookup.Provider)this.registryAccess());
    }

    @Override
    protected void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.readChestVehicleSaveData(pCompound, (HolderLookup.Provider)this.registryAccess());
    }

    public void destroy(@NotNull DamageSource pDamageSource) {
        super.destroy(pDamageSource);
        this.chestVehicleDestroyed(pDamageSource, this.level(), (Entity)this);
    }

    public void remove(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.RemovalReason pReason) {
        if (!this.level().isClientSide && pReason.shouldDestroy()) {
            Containers.dropContents((Level)this.level(), (Entity)this, (Container)this);
        }
        super.remove(pReason);
    }

    @NotNull
    public InteractionResult interact(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.canAddPassenger((Entity)pPlayer) && !pPlayer.isSecondaryUseActive()) {
            return super.interact(pPlayer, pHand);
        }
        InteractionResult interactionresult = this.interactWithContainerVehicle(pPlayer);
        if (interactionresult.consumesAction()) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
            PiglinAi.angerNearbyPiglins((Player)pPlayer, (boolean)true);
        }
        return interactionresult;
    }

    public void openCustomInventoryScreen(Player pPlayer) {
        pPlayer.openMenu((MenuProvider)this);
        if (!pPlayer.level().isClientSide) {
            this.gameEvent((Holder)GameEvent.CONTAINER_OPEN, (Entity)pPlayer);
            PiglinAi.angerNearbyPiglins((Player)pPlayer, (boolean)true);
        }
    }

    @Override
    @NotNull
    public Item getDropItem() {
        return switch (this.getBFTPBoatEntityType()) {
            case BFTPBoat.BoatType.CEDAR -> (Item)ModItems.CEDAR_CHEST_BOAT.get();
            default -> Items.OAK_CHEST_BOAT;
        };
    }

    public void clearContent() {
        this.clearChestVehicleContent();
    }

    public int getContainerSize() {
        return 27;
    }

    @NotNull
    public ItemStack getItem(int pSlot) {
        return this.getChestVehicleItem(pSlot);
    }

    @NotNull
    public ItemStack removeItem(int pSlot, int pAmount) {
        return this.removeChestVehicleItem(pSlot, pAmount);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int pSlot) {
        return this.removeChestVehicleItemNoUpdate(pSlot);
    }

    public void setItem(int pSlot, @NotNull ItemStack pStack) {
        this.setChestVehicleItem(pSlot, pStack);
    }

    @NotNull
    public SlotAccess getSlot(int pSlot) {
        return this.getChestVehicleSlot(pSlot);
    }

    public void setChanged() {
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return this.isChestVehicleStillValid(pPlayer);
    }

    public @Nullable AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        if (this.lootTable != null && pPlayer.isSpectator()) {
            return null;
        }
        this.unpackLootTable(pPlayerInventory.player);
        return ChestMenu.threeRows((int)pContainerId, (Inventory)pPlayerInventory, (Container)this);
    }

    public void unpackLootTable(@Nullable Player pPlayer) {
        this.unpackChestVehicleLootTable(pPlayer);
    }

    public @Nullable ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    public void setLootTable(@Nullable ResourceKey<LootTable> pLootTable) {
        this.lootTable = pLootTable;
    }

    @NotNull
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    }
}

