/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.boats;

import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import team.recrafted.blastfromthepast.init.ModBlocks;
import team.recrafted.blastfromthepast.init.ModEntities;
import team.recrafted.blastfromthepast.init.ModItems;
import team.recrafted.blastfromthepast.mixin.BoatAccessor;

public class BFTPBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.defineId(BFTPBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BFTPBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)ModEntities.BFTPBOAT.get()), level);
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public BFTPBoat(EntityType<? extends Boat> entityType, Level level) {
        super(entityType, level);
    }

    @NotNull
    public Item getDropItem() {
        switch (this.getBFTPBoatEntityType().ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
        }
        return (Item)ModItems.CEDAR_BOAT.get();
    }

    public BoatType getBFTPBoatEntityType() {
        return BoatType.byId((Integer)this.entityData.get(BOAT_TYPE));
    }

    public void setNWBoatEntityType(BoatType type) {
        this.entityData.set(BOAT_TYPE, (Object)type.ordinal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(BOAT_TYPE, (Object)BoatType.CEDAR.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("BoatType", this.getBFTPBoatEntityType().name);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("BoatType", 8)) {
            this.setNWBoatEntityType(BoatType.byName(compound.getString("BoatType")));
        }
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        ((BoatAccessor)((Object)this)).setLastYd(this.getDeltaMovement().y);
        if (!this.isPassenger()) {
            if (pOnGround) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Boat.Status.ON_LAND) {
                        this.resetFallDistance();
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getBFTPBoatEntityType().planks);
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.resetFallDistance();
            } else if (!this.canBoatInFluid(this.level().getFluidState(this.blockPosition().below())) && pY < 0.0) {
                this.fallDistance -= (float)pY;
            }
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity p_352110_) {
        return new ClientboundAddEntityPacket((Entity)this, p_352110_);
    }

    public static enum BoatType implements StringRepresentable
    {
        CEDAR((Block)ModBlocks.CEDAR.BLOCK.get(), "cedar");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<BoatType> CODEC;
        private static final IntFunction<BoatType> BY_ID;

        private BoatType(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        public String getSerializedName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public static BoatType byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static BoatType byName(String pName) {
            return (BoatType)CODEC.byName(pName, (Enum)CEDAR);
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        static {
            CODEC = StringRepresentable.fromEnum(BoatType::values);
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])BoatType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

