/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.navigation;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.mixin.WalkNodeEvaluatorAccess;

public class BFTPWalkNodeProcessor
extends WalkNodeEvaluator {
    public Node getStart() {
        int y;
        AABB boundingBox;
        BlockPos.MutableBlockPos mutableBlockPos;
        block11: {
            mutableBlockPos = new BlockPos.MutableBlockPos();
            boundingBox = this.mob.getBoundingBox();
            y = (int)boundingBox.minY;
            BlockState blockState = this.currentContext.getBlockState((BlockPos)mutableBlockPos.set(this.mob.getX(), (double)y, this.mob.getZ()));
            if (!this.mob.canStandOnFluid(blockState.getFluidState())) {
                if (this.canFloat() && this.mob.isInWater()) {
                    while (true) {
                        if (!blockState.is(Blocks.WATER) && blockState.getFluidState() != Fluids.WATER.getSource(false)) {
                            --y;
                            break block11;
                        }
                        blockState = this.currentContext.getBlockState((BlockPos)mutableBlockPos.set(this.mob.getX(), (double)(++y), this.mob.getZ()));
                    }
                }
                if (this.mob.onGround()) {
                    y = Mth.floor((double)(boundingBox.minY + 0.5));
                } else {
                    BlockPos blockPos = this.mob.blockPosition();
                    while ((this.currentContext.getBlockState(blockPos).isAir() || this.currentContext.getBlockState(blockPos).isPathfindable(PathComputationType.LAND)) && blockPos.getY() > this.mob.level().getMinBuildHeight()) {
                        blockPos = blockPos.below();
                    }
                    y = blockPos.above().getY();
                }
            } else {
                while (true) {
                    if (!this.mob.canStandOnFluid(blockState.getFluidState())) {
                        --y;
                        break;
                    }
                    blockState = this.currentContext.getBlockState((BlockPos)mutableBlockPos.set(this.mob.getX(), (double)(++y), this.mob.getZ()));
                }
            }
        }
        float radius = this.mob.getBbWidth() * 0.5f;
        int x = Mth.floor((double)(this.mob.getX() - (double)radius));
        int z = Mth.floor((double)(this.mob.getZ() - (double)radius));
        if (!this.canStartAt((BlockPos)mutableBlockPos.set(x, y, z)) && (this.canStartAt((BlockPos)mutableBlockPos.set(boundingBox.minX - (double)radius, (double)y, boundingBox.minZ - (double)radius)) || this.canStartAt((BlockPos)mutableBlockPos.set(boundingBox.minX - (double)radius, (double)y, boundingBox.maxZ - (double)radius)) || this.canStartAt((BlockPos)mutableBlockPos.set(boundingBox.maxX - (double)radius, (double)y, boundingBox.minZ - (double)radius)) || this.canStartAt((BlockPos)mutableBlockPos.set(boundingBox.maxX - (double)radius, (double)y, boundingBox.maxZ - (double)radius)))) {
            return this.getStartNode((BlockPos)mutableBlockPos);
        }
        return this.getStartNode(BlockPos.containing((double)x, (double)y, (double)z));
    }

    @Nullable
    protected Node findAcceptedNode(int x, int y, int z, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType) {
        Node node = null;
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        double floorLevel = this.getFloorLevel((BlockPos)blockpos$mutableblockpos.set(x, y, z));
        if (floorLevel - nodeFloorLevel > ((WalkNodeEvaluatorAccess)((Object)this)).callGetMobJumpHeight()) {
            return null;
        }
        PathType pathtype = this.getCachedPathType(x, y, z);
        float pathfindingMalus = this.mob.getPathfindingMalus(pathtype);
        double radius = (double)this.mob.getBbWidth() / 2.0;
        if (pathfindingMalus >= 0.0f) {
            node = ((WalkNodeEvaluatorAccess)((Object)this)).callGetNodeAndUpdateCostToMax(x, y, z, pathtype, pathfindingMalus);
        }
        if (WalkNodeEvaluatorAccess.callDoesBlockHavePartialCollision(pathType) && node != null && node.costMalus >= 0.0f && !((WalkNodeEvaluatorAccess)((Object)this)).callCanReachWithoutCollision(node)) {
            node = null;
        }
        if (!(pathtype == PathType.WALKABLE || this.isAmphibious() && pathtype == PathType.WATER)) {
            if ((node == null || node.costMalus < 0.0f) && verticalDeltaLimit > 0 && (pathtype != PathType.FENCE || this.canWalkOverFences()) && pathtype != PathType.UNPASSABLE_RAIL && pathtype != PathType.TRAPDOOR && pathtype != PathType.POWDER_SNOW) {
                node = ((WalkNodeEvaluatorAccess)((Object)this)).callTryJumpOn(x, y, z, verticalDeltaLimit, nodeFloorLevel, direction, pathType, blockpos$mutableblockpos);
            } else if (!this.isAmphibious() && pathtype == PathType.WATER && !this.canFloat()) {
                node = ((WalkNodeEvaluatorAccess)((Object)this)).callTryFindFirstNonWaterBelow(x, y, z, node);
            } else if (pathtype == PathType.OPEN) {
                PathType down;
                AABB collision = new AABB((double)x - radius + (double)this.entityWidth * 0.5, (double)y + 0.001, (double)z - radius + (double)this.entityDepth * 0.5, (double)x + radius + (double)this.entityWidth * 0.5, (double)((float)y + this.mob.getBbHeight()), (double)z + radius + (double)this.entityDepth * 0.5);
                if (((WalkNodeEvaluatorAccess)((Object)this)).callHasCollisions(collision)) {
                    return null;
                }
                if (this.mob.getBbWidth() >= 1.0f && (down = this.getCachedPathType(x, y - 1, z)) == PathType.BLOCKED) {
                    node = this.getNode(x, y, z);
                    node.type = PathType.WALKABLE;
                    node.costMalus = Math.max(node.costMalus, pathfindingMalus);
                    return node;
                }
                node = ((WalkNodeEvaluatorAccess)((Object)this)).callTryFindFirstGroundNodeBelow(x, y, z);
            } else if (WalkNodeEvaluatorAccess.callDoesBlockHavePartialCollision(pathtype) && node == null) {
                node = ((WalkNodeEvaluatorAccess)((Object)this)).callGetClosedNode(x, y, z, pathtype);
            }
            return node;
        }
        return node;
    }

    public PathType getBlockPathTypeWithCustomEntitySize(PathfindingContext pathfindingContext, int pX, int pY, int pZ, Mob pMob, int entityWidth, int entityHeight, int entityDepth) {
        EnumSet<PathType> blockPathTypes = EnumSet.noneOf(PathType.class);
        PathType blockPathType = PathType.BLOCKED;
        blockPathType = this.getPathTypeWithCustomEntitySize(pathfindingContext, pX, pY, pZ, blockPathTypes, blockPathType, pMob.blockPosition(), entityWidth, entityHeight, entityDepth);
        if (blockPathTypes.contains(PathType.FENCE)) {
            return PathType.FENCE;
        }
        if (blockPathTypes.contains(PathType.UNPASSABLE_RAIL)) {
            return PathType.UNPASSABLE_RAIL;
        }
        PathType blockpathtypes1 = PathType.BLOCKED;
        for (PathType blockpathtypes2 : blockPathTypes) {
            if (pMob.getPathfindingMalus(blockpathtypes2) < 0.0f) {
                return blockpathtypes2;
            }
            if (!(pMob.getPathfindingMalus(blockpathtypes2) >= pMob.getPathfindingMalus(blockpathtypes1))) continue;
            blockpathtypes1 = blockpathtypes2;
        }
        return blockPathType == PathType.OPEN && pMob.getPathfindingMalus(blockpathtypes1) == 0.0f && this.entityWidth <= 1 ? PathType.OPEN : blockpathtypes1;
    }

    private PathType getPathTypeWithCustomEntitySize(PathfindingContext pathfindingContext, int pXOffset, int pYOffset, int pZOffset, EnumSet<PathType> pOutput, PathType resultType, BlockPos pPos, int entityWidth, int entityHeight, int entityDepth) {
        for (int xStep = 0; xStep < entityWidth; ++xStep) {
            for (int yStep = 0; yStep < entityHeight; ++yStep) {
                for (int zStep = 0; zStep < entityDepth; ++zStep) {
                    int x = xStep + pXOffset;
                    int y = yStep + pYOffset;
                    int z = zStep + pZOffset;
                    PathType currentType = this.getPathType(pathfindingContext, x, y, z);
                    currentType = this.evaluateBlockPathType(pathfindingContext, pPos, currentType);
                    if (xStep == 0 && yStep == 0 && zStep == 0) {
                        resultType = currentType;
                    }
                    pOutput.add(currentType);
                }
            }
        }
        return resultType;
    }

    protected PathType evaluateBlockPathType(PathfindingContext pathfindingContext, BlockPos pPos, PathType pPathTypes) {
        boolean flag = this.canPassDoors();
        if (pPathTypes == PathType.DOOR_WOOD_CLOSED && this.canOpenDoors() && flag) {
            pPathTypes = PathType.WALKABLE_DOOR;
        }
        if (pPathTypes == PathType.DOOR_OPEN && !flag) {
            pPathTypes = PathType.BLOCKED;
        }
        if (pPathTypes == PathType.RAIL && this.getPathType(pathfindingContext, pPos.getX(), pPos.getY(), pPos.getZ()) != PathType.RAIL && this.getPathType(pathfindingContext, pPos.getX(), pPos.getY() - 1, pPos.getZ()) != PathType.RAIL) {
            pPathTypes = PathType.UNPASSABLE_RAIL;
        }
        return pPathTypes;
    }
}

