/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.navigation;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzurePathFinder;

public class AzureNavigation
extends GroundPathNavigation {
    static final float EPSILON = 1.0E-8f;
    @Nullable
    protected BlockPos pathToPosition;

    public AzureNavigation(Mob entity, Level world) {
        super(entity, world);
    }

    @NotNull
    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new WalkNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new AzurePathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    public void hardStop() {
        this.path = null;
        this.pathToPosition = null;
    }

    protected void trimPath() {
        super.trimPath();
        for (int i = 0; i < this.path.getNodeCount(); ++i) {
            Node node = this.path.getNode(i);
            Node node2 = i + 1 < this.path.getNodeCount() ? this.path.getNode(i + 1) : null;
            BlockState blockState = this.level.getBlockState(new BlockPos(node.x, node.y, node.z));
            if (!blockState.is(BlockTags.STAIRS)) continue;
            this.path.replaceNode(i, node.cloneAndMove(node.x, node.y + 1, node.z));
            if (node2 == null || node.y < node2.y) continue;
            this.path.replaceNode(i + 1, node.cloneAndMove(node2.x, node.y + 1, node2.z));
        }
    }

    protected void followThePath() {
        Path path = Objects.requireNonNull(this.path);
        Vec3 entityPos = this.getTempMobPos();
        int pathLength = path.getNodeCount();
        for (int i = path.getNextNodeIndex(); i < path.getNodeCount(); ++i) {
            if ((double)path.getNode((int)i).y == Math.floor(entityPos.y)) continue;
            pathLength = i;
            break;
        }
        Vec3 base = entityPos.add((double)(-this.mob.getBbWidth() * 0.5f), 0.0, (double)(-this.mob.getBbWidth() * 0.5f));
        Vec3 max = base.add((double)this.mob.getBbWidth(), (double)this.mob.getBbHeight(), (double)this.mob.getBbWidth());
        if (this.tryShortcut(path, new Vec3(this.mob.getX(), this.mob.getY(), this.mob.getZ()), pathLength, base, max) && (this.isAt(path, 0.5f) || this.atElevationChange(path) && this.isAt(path, this.mob.getBbWidth() * 0.5f))) {
            path.setNextNodeIndex(path.getNextNodeIndex() + 1);
        }
        this.doStuckDetection(entityPos);
    }

    public Path createPath(BlockPos blockPos, int i) {
        this.pathToPosition = blockPos;
        return super.createPath(blockPos, i);
    }

    public Path createPath(Entity entity, int i) {
        this.pathToPosition = entity.blockPosition();
        return super.createPath(entity, i);
    }

    public boolean moveTo(Entity entity, double d) {
        Path path = this.createPath(entity, 0);
        if (path != null) {
            return this.moveTo(path, d);
        }
        this.pathToPosition = entity.blockPosition();
        this.speedModifier = d;
        return true;
    }

    public void tick() {
        super.tick();
        if (this.isDone()) {
            if (this.pathToPosition != null) {
                if (this.pathToPosition.closerToCenterThan((Position)this.mob.position(), (double)this.mob.getBbWidth()) || this.mob.getY() > (double)this.pathToPosition.getY() && BlockPos.containing((double)this.pathToPosition.getX(), (double)this.mob.getY(), (double)this.pathToPosition.getZ()).closerToCenterThan((Position)this.mob.position(), (double)this.mob.getBbWidth())) {
                    this.pathToPosition = null;
                } else {
                    this.mob.getMoveControl().setWantedPosition((double)this.pathToPosition.getX(), (double)this.pathToPosition.getY(), (double)this.pathToPosition.getZ(), this.speedModifier);
                }
            }
            return;
        }
        if (this.getTargetPos() != null) {
            this.mob.getLookControl().setLookAt((double)this.getTargetPos().getX(), (double)this.getTargetPos().getY(), (double)this.getTargetPos().getZ());
        }
    }

    private boolean isAt(Path path, float threshold) {
        Vec3 pathPos = path.getNextEntityPos((Entity)this.mob);
        return Mth.abs((float)((float)(this.mob.getX() - pathPos.x))) < threshold && Mth.abs((float)((float)(this.mob.getZ() - pathPos.z))) < threshold && Math.abs(this.mob.getY() - pathPos.y) < 1.0;
    }

    private boolean atElevationChange(Path path) {
        int curr = path.getNextNodeIndex();
        int end = Math.min(path.getNodeCount(), curr + Mth.ceil((float)(this.mob.getBbWidth() * 0.5f)) + 1);
        int currY = path.getNode((int)curr).y;
        for (int i = curr + 1; i < end; ++i) {
            if (path.getNode((int)i).y == currY) continue;
            return true;
        }
        return false;
    }

    private boolean tryShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base, Vec3 max) {
        int i = pathLength;
        while (--i > path.getNextNodeIndex()) {
            Vec3 vec = path.getEntityPosAtNode((Entity)this.mob, i).subtract(entityPos);
            if (!this.sweep(vec, base, max)) continue;
            path.setNextNodeIndex(i);
            return false;
        }
        return true;
    }

    private boolean sweep(Vec3 vec, Vec3 base, Vec3 max) {
        float t = 0.0f;
        float max_t = (float)vec.length();
        if (max_t < 1.0E-8f) {
            return true;
        }
        float[] tr = new float[3];
        int[] ldi = new int[3];
        int[] tri = new int[3];
        int[] step = new int[3];
        float[] tDelta = new float[3];
        float[] tNext = new float[3];
        float[] normed = new float[3];
        for (int i = 0; i < 3; ++i) {
            float value = AzureNavigation.element(vec, i);
            boolean dir = value >= 0.0f;
            step[i] = dir ? 1 : -1;
            float lead = AzureNavigation.element(dir ? max : base, i);
            tr[i] = AzureNavigation.element(dir ? base : max, i);
            ldi[i] = AzureNavigation.leadEdgeToInt(lead, step[i]);
            tri[i] = AzureNavigation.trailEdgeToInt(tr[i], step[i]);
            normed[i] = value / max_t;
            tDelta[i] = Mth.abs((float)(max_t / value));
            float dist = dir ? (float)(ldi[i] + 1) - lead : lead - (float)ldi[i];
            tNext[i] = tDelta[i] < Float.POSITIVE_INFINITY ? tDelta[i] * dist : Float.POSITIVE_INFINITY;
        }
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        do {
            int axis = tNext[0] < tNext[1] ? (tNext[0] < tNext[2] ? 0 : 2) : (tNext[1] < tNext[2] ? 1 : 2);
            float dt = tNext[axis] - t;
            t = tNext[axis];
            int n = axis;
            ldi[n] = ldi[n] + step[axis];
            int n2 = axis;
            tNext[n2] = tNext[n2] + tDelta[axis];
            for (int i = 0; i < 3; ++i) {
                int n3 = i;
                tr[n3] = tr[n3] + dt * normed[i];
                tri[i] = AzureNavigation.trailEdgeToInt(tr[i], step[i]);
            }
            int stepx = step[0];
            int x0 = axis == 0 ? ldi[0] : tri[0];
            int x1 = ldi[0] + stepx;
            int stepy = step[1];
            int y0 = axis == 1 ? ldi[1] : tri[1];
            int y1 = ldi[1] + stepy;
            int stepz = step[2];
            int z0 = axis == 2 ? ldi[2] : tri[2];
            int z1 = ldi[2] + stepz;
            for (int x = x0; x != x1; x += stepx) {
                for (int z = z0; z != z1; z += stepz) {
                    for (int y = y0; y != y1; y += stepy) {
                        BlockState block = this.level.getBlockState((BlockPos)pos.set(x, y, z));
                        if (block.isPathfindable(PathComputationType.LAND)) continue;
                        return false;
                    }
                    PathType below = this.nodeEvaluator.getPathType(new PathfindingContext((CollisionGetter)this.mob.level(), this.mob), x, y0 - 1, z);
                    if (below == PathType.WATER || below == PathType.LAVA || below == PathType.OPEN) {
                        return false;
                    }
                    PathType in = this.nodeEvaluator.getPathType(new PathfindingContext((CollisionGetter)this.mob.level(), this.mob), x, y0, z);
                    float priority = this.mob.getPathfindingMalus(in);
                    if (priority < 0.0f || priority >= 8.0f) {
                        return false;
                    }
                    if (in != PathType.DAMAGE_FIRE && in != PathType.DANGER_FIRE && in != PathType.DAMAGE_OTHER) continue;
                    return false;
                }
            }
        } while (t <= max_t);
        return true;
    }

    static int leadEdgeToInt(float coord, int step) {
        return Mth.floor((float)(coord - (float)step * 1.0E-8f));
    }

    static int trailEdgeToInt(float coord, int step) {
        return Mth.floor((float)(coord + (float)step * 1.0E-8f));
    }

    static float element(Vec3 v, int i) {
        switch (i) {
            case 0: {
                return (float)v.x;
            }
            case 1: {
                return (float)v.y;
            }
            case 2: {
                return (float)v.z;
            }
        }
        return 0.0f;
    }
}

