/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.roar;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.Roaring;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;
import team.recrafted.blastfromthepast.util.HitboxHelper;

public class RoarAtTargetGoal<T extends Mob>
extends Goal {
    private final T mob;
    private boolean didRoar = false;
    @Nullable
    private LivingEntity lastKnownTarget;
    private final double maxDistSqrToTarget;

    public RoarAtTargetGoal(T mob, double maxDistToTarget) {
        this.mob = mob;
        this.maxDistSqrToTarget = Mth.square((double)maxDistToTarget);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        LivingEntity target;
        if (this.lastKnownTarget != null && (this.lastKnownTarget.isRemoved() || HitboxHelper.getDistSqrBetweenHitboxes(this.mob, (Entity)this.lastKnownTarget) > Mth.square((double)EntityHelper.getFollowRange(this.mob)))) {
            this.lastKnownTarget = null;
        }
        if (this.lastKnownTarget != (target = this.mob.getTarget())) {
            boolean canUse;
            this.lastKnownTarget = target;
            boolean bl = canUse = target != null && HitboxHelper.getDistSqrBetweenHitboxes(this.mob, (Entity)target) > this.maxDistSqrToTarget;
            if (canUse && DebugFlags.DEBUG_ROAR) {
                BlastFromThePast.LOGGER.info("{} wants to roar at {}", this.mob, (Object)target);
            }
            return canUse;
        }
        return false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void start() {
        this.lookOrRoarAtTarget();
    }

    private void lookOrRoarAtTarget() {
        LivingEntity target = this.mob.getTarget();
        if (target != null && !((Roaring)this.mob).isRoaring()) {
            if (this.isFacingTarget(target)) {
                if (!this.didRoar) {
                    ((Roaring)this.mob).roarIfPossible();
                    if (((Roaring)this.mob).isRoaring()) {
                        if (DebugFlags.DEBUG_ROAR) {
                            BlastFromThePast.LOGGER.info("{} started roaring at {}", this.mob, (Object)target);
                        }
                        this.didRoar = true;
                    }
                }
            } else {
                this.mob.getLookControl().setLookAt((Entity)target, 30.0f, 30.0f);
            }
        } else if (this.mob.getRandom().nextIntBetweenInclusive(1, 2500) == 1 && !this.didRoar) {
            ((Roaring)this.mob).roarIfPossible();
            if (((Roaring)this.mob).isRoaring()) {
                if (DebugFlags.DEBUG_ROAR) {
                    BlastFromThePast.LOGGER.info("{} started roaring at {}", this.mob, (Object)target);
                }
                this.didRoar = true;
            }
        }
    }

    protected boolean isFacingTarget(LivingEntity target) {
        return EntityHelper.isLookingAt(this.mob, target, 0.025, false, true);
    }

    public boolean canContinueToUse() {
        if (((Roaring)this.mob).isRoaring()) {
            return true;
        }
        if (this.didRoar) {
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        return target != null && HitboxHelper.getDistSqrBetweenHitboxes(this.mob, (Entity)target) > this.maxDistSqrToTarget;
    }

    public void tick() {
        this.lookOrRoarAtTarget();
    }

    public void stop() {
        if (DebugFlags.DEBUG_ROAR) {
            BlastFromThePast.LOGGER.info("{} finished roaring at target", this.mob);
        }
        this.didRoar = false;
    }
}

