/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.complex_animal;

import java.util.EnumSet;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.util.DebugFlags;

public class SleepGoal<T extends Mob>
extends Goal {
    public static final int WAIT_TIME_BEFORE_SLEEP = SleepGoal.reducedTickDelay((int)340);
    protected final T mob;
    protected int countdown;

    public SleepGoal(T mob) {
        this.mob = mob;
        this.countdown = this.mob.getRandom().nextInt(WAIT_TIME_BEFORE_SLEEP);
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        return ((Mob)this.mob).xxa == 0.0f && ((Mob)this.mob).yya == 0.0f && this.canSleep();
    }

    public boolean canContinueToUse() {
        return this.canSleep();
    }

    private boolean canSleep() {
        if (this.countdown > 0) {
            --this.countdown;
            return false;
        }
        return ((ComplexAnimal)this.mob).canSleep();
    }

    public void stop() {
        if (DebugFlags.DEBUG_SLEEP) {
            BlastFromThePast.LOGGER.info("{} has stopped sleeping!", this.mob);
        }
        this.countdown = this.mob.getRandom().nextInt(WAIT_TIME_BEFORE_SLEEP);
        ((ComplexAnimal)this.mob).clearStates();
    }

    public void start() {
        if (DebugFlags.DEBUG_SLEEP) {
            BlastFromThePast.LOGGER.info("{} has started sleeping!", this.mob);
        }
        ((ComplexAnimal)this.mob).prepareToStartSleeping();
        ((ComplexAnimal)this.mob).setSleeping(true);
        this.mob.getNavigation().stop();
        this.mob.getMoveControl().setWantedPosition(this.mob.getX(), this.mob.getY(), this.mob.getZ(), 0.0);
    }
}

