/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.complex_animal;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import team.recrafted.blastfromthepast.BlastFromThePast;
import team.recrafted.blastfromthepast.entity.misc.ComplexAnimal;
import team.recrafted.blastfromthepast.util.DebugFlags;
import team.recrafted.blastfromthepast.util.EntityHelper;

public class SeekShelterGoal<T extends PathfinderMob>
extends FleeSunGoal {
    private final T complexAnimal;
    private int interval = SeekShelterGoal.reducedTickDelay((int)100);

    public SeekShelterGoal(T mob, double speedModifier) {
        super(mob, speedModifier);
        this.complexAnimal = mob;
    }

    public boolean canUse() {
        if (!this.mob.isSleeping() && this.mob.getTarget() == null) {
            if (((ComplexAnimal)this.complexAnimal).shouldFindShelter(true)) {
                return this.setWantedPos();
            }
            if (this.interval > 0) {
                --this.interval;
                return false;
            }
            this.interval = 100;
            return ((ComplexAnimal)this.complexAnimal).shouldFindShelter(false) && this.setWantedPos();
        }
        return false;
    }

    public void start() {
        if (DebugFlags.DEBUG_SLEEP) {
            BlastFromThePast.LOGGER.info("{} is seeking shelter!", (Object)this.mob);
        }
        ((ComplexAnimal)this.complexAnimal).clearStates();
        super.start();
    }

    public void stop() {
        super.stop();
        if (DebugFlags.DEBUG_SLEEP) {
            BlastFromThePast.LOGGER.info("{} is no longer seeking shelter!", (Object)this.mob);
        }
    }

    @Nullable
    protected Vec3 getHidePos() {
        RandomSource random = this.mob.getRandom();
        BlockPos currentPos = this.mob.blockPosition();
        PathfindingContext context = new PathfindingContext((CollisionGetter)this.mob.level(), (Mob)this.mob);
        BlockPos.MutableBlockPos targetPos = currentPos.mutable();
        for (int i = 0; i < 10; ++i) {
            if (!EntityHelper.hasBlocksAbove(this.mob, (BlockPos)(targetPos = targetPos.set((Vec3i)currentPos).move(random.nextInt(20) - 10, random.nextInt(6) - 3, random.nextInt(20) - 10))) || this.mob.getPathfindingMalus(WalkNodeEvaluator.getPathTypeStatic((PathfindingContext)context, (BlockPos.MutableBlockPos)targetPos)) != 0.0f) continue;
            return Vec3.atBottomCenterOf((Vec3i)targetPos);
        }
        return null;
    }
}

