/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.charge;

import java.util.EnumSet;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.entity.misc.ChargeForward;
import team.recrafted.blastfromthepast.mixin.LivingEntityAccessor;

public class ChargeForwardAttackGoal<T extends PathfinderMob>
extends Goal {
    private final T mob;
    private final UniformInt duration;
    private final double speedModifier;
    private long endTimestamp = 0L;

    public ChargeForwardAttackGoal(T mob, UniformInt duration, double speedModifier) {
        this.mob = mob;
        this.duration = duration;
        this.speedModifier = speedModifier;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return ((ChargeForward)this.mob).isChargingForward();
    }

    public void start() {
        this.mob.getNavigation().stop();
        int duration = this.duration.sample(this.mob.getRandom());
        this.endTimestamp = this.mob.level().getGameTime() + (long)duration;
    }

    public boolean canContinueToUse() {
        return ((ChargeForward)this.mob).isChargingForward() && !this.mob.hasRestriction() && this.mob.level().getGameTime() <= this.endTimestamp;
    }

    public void tick() {
        Vec3 look = this.mob.getViewVector(1.0f);
        Vec3 motion = this.mob.getDeltaMovement();
        double speed = this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED) * this.speedModifier * (double)((LivingEntityAccessor)this.mob).callGetBlockSpeedFactor();
        this.mob.setDeltaMovement(look.x * speed, motion.y, look.z * speed);
        ((PathfinderMob)this.mob).hasImpulse = true;
    }

    public void stop() {
        this.mob.getNavigation().stop();
        ((ChargeForward)this.mob).setIsChargingForward(false);
    }
}

