/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.burrel;

import java.util.EnumSet;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import team.recrafted.blastfromthepast.entity.BurrelEntity;

public class BurrelSleepGoal
extends Goal {
    private final BurrelEntity burrel;

    public BurrelSleepGoal(BurrelEntity burrel) {
        this.burrel = burrel;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public void start() {
        this.burrel.setSleeping(true);
        this.burrel.getNavigation().stop();
        this.burrel.getMoveControl().setWantedPosition(this.burrel.getX(), this.burrel.getY(), this.burrel.getZ(), 0.0);
        this.burrel.setDeltaMovement(0.0, 0.0, 0.0);
    }

    public boolean canUse() {
        if (this.burrel.isBaby()) {
            return false;
        }
        return this.canContinueToUse();
    }

    public boolean canContinueToUse() {
        return !this.burrel.isPanicking() && this.burrelOnTree() && this.burrel.level().isNight();
    }

    public boolean burrelOnTree() {
        BlockState blockState = this.burrel.level().getBlockState(this.burrel.blockPosition().below());
        if (blockState.is(BlockTags.LEAVES)) {
            return true;
        }
        if (!blockState.isAir()) {
            return false;
        }
        return this.burrel.level().getBlockState(this.burrel.blockPosition().below(2)).is(BlockTags.LEAVES);
    }

    public void stop() {
        this.burrel.setSleeping(false);
    }
}

