/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.burrel;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.entity.BurrelEntity;

public class BurrelRandomStrollGoal
extends WaterAvoidingRandomStrollGoal {
    private final BurrelEntity burrel;
    private int cooldown;
    private boolean onTree;

    public BurrelRandomStrollGoal(BurrelEntity mob, double speedModifier) {
        super((PathfinderMob)mob, speedModifier);
        this.burrel = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.onTree ? this.speedModifier : 0.5);
        this.burrel.getLookControl().setLookAt(this.wantedX, this.wantedY, this.wantedZ);
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 pos = super.getPosition();
        boolean bl = this.onTree = !this.burrel.wantsToBeOnGround() && this.onTree(this.burrel.blockPosition());
        if (this.onTree) {
            if (this.cooldown > 0) {
                --this.cooldown;
                return null;
            }
            if (pos == null) {
                for (int i = 0; i <= 10; ++i) {
                    RandomSource randomSource = this.burrel.getRandom();
                    BlockPos pos1 = BlockPos.containing((Position)this.burrel.position().add((double)randomSource.nextIntBetweenInclusive(-3, 3), (double)randomSource.nextIntBetweenInclusive(-3, 3), (double)randomSource.nextIntBetweenInclusive(-3, 3)));
                    BlockState blockState1 = this.burrel.level().getBlockState(pos1);
                    if (!blockState1.isAir() && !blockState1.is(Blocks.SNOW) || !this.burrel.level().getBlockState(pos1.below()).is(BlockTags.LEAVES)) continue;
                    pos = pos1.getCenter().subtract(0.0, 0.5, 0.0);
                }
            } else if (this.burrel.level().getBlockState(this.burrel.blockPosition().below()).is(BlockTags.LEAVES) && !this.burrel.level().getBlockState(BlockPos.containing((Position)pos.subtract(0.0, 1.0, 0.0))).is(BlockTags.LEAVES)) {
                return null;
            }
            if (pos == null || pos.distanceTo(this.burrel.position()) < 2.0 || !this.onTree(new BlockPos((int)pos.x(), (int)pos.y(), (int)pos.z()))) {
                return null;
            }
            this.cooldown += 100;
        }
        return pos;
    }

    public boolean onTree(BlockPos pos) {
        BlockState blockState = this.burrel.level().getBlockState(pos.below());
        if (blockState.is(BlockTags.LEAVES)) {
            return true;
        }
        if (!blockState.isAir()) {
            return false;
        }
        return this.burrel.level().getBlockState(this.burrel.blockPosition().below(2)).is(BlockTags.LEAVES);
    }
}

