/*
 * Decompiled with CFR 0.152.
 */
package team.recrafted.blastfromthepast.entity.ai.goal.burrel;

import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import team.recrafted.blastfromthepast.entity.BurrelEntity;
import team.recrafted.blastfromthepast.entity.ai.navigation.AzureNavigation;

public class BurrelGoToTreesGoal
extends Goal {
    private final BurrelEntity burrel;
    private final double speed;
    private BlockPos target;

    public BurrelGoToTreesGoal(BurrelEntity burrel, double speed) {
        this.burrel = burrel;
        this.speed = speed;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean canUse() {
        if (this.burrel.isBaby()) {
            return false;
        }
        if (this.burrel.isBesideClimbableBlock() || this.burrel.wantsToBeOnGround() || this.burrel.getNavigation().isInProgress() || this.burrel.isPanicking() || this.burrel.level().getBlockState(this.burrel.blockPosition().below()).is(BlockTags.LEAVES)) {
            return false;
        }
        BlockPos burrelPos = this.burrel.blockPosition();
        for (int x = -10; x <= 10; ++x) {
            for (int z = -10; z <= 10; ++z) {
                BlockPos checkPos = burrelPos.offset(x, 0, z);
                if (!this.goodTarget(checkPos) || !this.isTree(checkPos)) continue;
                for (int y = -5; y < 0; ++y) {
                    BlockPos checkPos2 = checkPos.offset(0, y, 0);
                    if (!this.goodTarget(checkPos2)) continue;
                    this.burrel.targetTree = checkPos2;
                    return true;
                }
                this.burrel.targetTree = checkPos;
                return true;
            }
        }
        return false;
    }

    public boolean isTree(BlockPos pos) {
        BlockState blockState;
        do {
            pos = pos.above();
            blockState = this.burrel.level().getBlockState(pos);
            if (!blockState.is(BlockTags.LEAVES)) continue;
            return true;
        } while (blockState.is(BlockTags.LOGS));
        return false;
    }

    public boolean goodTarget(BlockPos pos) {
        return this.burrel.level().getBlockState(pos).is(BlockTags.LOGS) && this.hasLineOfSightWithBlock(pos);
    }

    public void start() {
        AzureNavigation navigation = (AzureNavigation)this.burrel.getNavigation();
        this.target = this.getClimbingPosition(this.burrel.targetTree);
        navigation.moveTo(navigation.createPath(this.target, 1), this.speed);
        Vec3 targetCentre = this.target.getCenter();
        this.burrel.getLookControl().setLookAt(targetCentre.x(), targetCentre.y(), targetCentre.z());
    }

    private BlockPos getClimbingPosition(BlockPos pos) {
        BlockHitResult hitResult = (BlockHitResult)this.rayTrace(pos);
        switch (hitResult.getDirection()) {
            case EAST: {
                return pos.east();
            }
            case WEST: {
                return pos.west();
            }
            case NORTH: {
                return pos.north();
            }
            case SOUTH: {
                return pos.south();
            }
        }
        return pos;
    }

    private boolean hasLineOfSightWithBlock(BlockPos pos) {
        HitResult result = this.rayTrace(pos);
        return result.getType() == HitResult.Type.BLOCK && ((BlockHitResult)result).getBlockPos().getCenter().equals((Object)pos.getCenter()) && ((BlockHitResult)result).getDirection() != Direction.DOWN && ((BlockHitResult)result).getDirection() != Direction.UP;
    }

    private HitResult rayTrace(BlockPos pos) {
        Vec2 lookDirection = this.lookAngle(EntityAnchorArgument.Anchor.EYES, pos.getCenter());
        Vec3 eyePosition = this.burrel.getEyePosition();
        Vec3 endPosition = this.calculateViewVector(lookDirection.x, lookDirection.y).scale(20.0).add(eyePosition);
        return this.burrel.level().clip(new ClipContext(eyePosition, endPosition, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.burrel));
    }

    protected final Vec3 calculateViewVector(float xRot, float yRot) {
        float f = xRot * ((float)Math.PI / 180);
        float g = -yRot * ((float)Math.PI / 180);
        float h = Mth.cos((float)g);
        float i = Mth.sin((float)g);
        float j = Mth.cos((float)f);
        float k = Mth.sin((float)f);
        return new Vec3((double)(i * j), (double)(-k), (double)(h * j));
    }

    public Vec2 lookAngle(EntityAnchorArgument.Anchor anchor, Vec3 target) {
        Vec3 vec3 = anchor.apply((Entity)this.burrel);
        double d = target.x - vec3.x;
        double e = target.y - vec3.y;
        double f = target.z - vec3.z;
        double g = Math.sqrt(d * d + f * f);
        return new Vec2(Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)e, (double)g) * 57.2957763671875)))), Mth.wrapDegrees((float)((float)(Mth.atan2((double)f, (double)d) * 57.2957763671875) - 90.0f)));
    }

    public void tick() {
        Vec3 vec3 = this.target.getCenter();
        if (this.burrel.distanceToSqr(vec3.x, this.burrel.getY(), vec3.z) <= 2.0) {
            Vec3 vec = new Vec3((double)this.target.getX() + 0.5, this.burrel.getY(), (double)this.target.getZ() + 0.5).subtract(this.burrel.position());
            this.burrel.setPos(this.burrel.position().add(vec.scale(0.1)));
        }
        if (this.burrel.distanceToSqr(vec3.x, this.burrel.getY(), vec3.z) <= 0.5) {
            this.burrel.setPos(new Vec3((double)this.target.getX() + 0.5, this.burrel.getY(), (double)this.target.getZ() + 0.5));
            this.burrel.setBesideClimbableBlock(true);
        }
    }

    public boolean canContinueToUse() {
        BlockPos treePos = this.target;
        return this.burrel.targetTree != null && treePos != null && !this.burrel.isBesideClimbableBlock() && !this.burrel.getNavigation().isDone() && !(this.burrel.distanceToSqr(treePos.getX(), treePos.getY(), treePos.getZ()) <= 2.0) && !this.burrel.isPanicking() && !this.burrel.wantsToBeOnGround();
    }

    public void stop() {
        BlockPos treePos = this.burrel.targetTree;
        if (treePos != null && this.burrel.distanceToSqr(treePos.getX(), this.burrel.getY(), treePos.getZ()) <= 2.0) {
            this.burrel.moveTo(this.target.getCenter());
            this.burrel.setBesideClimbableBlock(true);
        }
        this.burrel.getNavigation().stop();
    }
}

